/*
 * Decompiled with CFR 0.152.
 */
package dev.youshallnotpass.inspections.allfinal.nonfinals;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import dev.youshallnotpass.inspection.InspectionException;
import dev.youshallnotpass.inspection.InspectionScalar;
import dev.youshallnotpass.inspection.JavaViolations;
import dev.youshallnotpass.inspection.Violations;
import dev.youshallnotpass.inspections.allfinal.nonfinals.JavaNonfinal;
import dev.youshallnotpass.inspections.allfinal.nonfinals.Nonfinal;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public final class JavaNonfinals
implements Violations<Nonfinal> {
    private final Violations<Nonfinal> statics;

    public JavaNonfinals(String ... lines) {
        this(ParserConfiguration.LanguageLevel.RAW, lines);
    }

    public JavaNonfinals(ParserConfiguration.LanguageLevel level, String ... lines) {
        this(new JavaParser(new ParserConfiguration().setLanguageLevel(level)), lines);
    }

    public JavaNonfinals(JavaParser parser, String ... lines) {
        this(parser, new InspectionScalar<InputStream>(() -> {
            StringBuilder source = new StringBuilder();
            for (String line : lines) {
                source.append(line);
            }
            return new ByteArrayInputStream(source.toString().getBytes(StandardCharsets.UTF_8));
        }), String.join((CharSequence)"", lines));
    }

    public JavaNonfinals(String source) {
        this(ParserConfiguration.LanguageLevel.RAW, source);
    }

    public JavaNonfinals(ParserConfiguration.LanguageLevel level, String source) {
        this(new JavaParser(new ParserConfiguration().setLanguageLevel(level)), source);
    }

    public JavaNonfinals(JavaParser parser, String source) {
        this(parser, new InspectionScalar<InputStream>(() -> new ByteArrayInputStream(source.getBytes(StandardCharsets.UTF_8))), source);
    }

    public JavaNonfinals(File file) {
        this(ParserConfiguration.LanguageLevel.RAW, file);
    }

    public JavaNonfinals(ParserConfiguration.LanguageLevel level, File file) {
        this(new JavaParser(new ParserConfiguration().setLanguageLevel(level)), file);
    }

    public JavaNonfinals(JavaParser parser, File file) {
        this(parser, new InspectionScalar<InputStream>(() -> {
            try {
                return new FileInputStream(file);
            }
            catch (IOException e) {
                throw new InspectionException(String.format("Can not get an input stream from the file: %s", file), e);
            }
        }), file.getAbsolutePath());
    }

    public JavaNonfinals(JavaParser parser, InspectionScalar<InputStream> source, String descriptor) {
        this(new JavaViolations<Nonfinal>(source, parser, descriptor, (unit, root) -> {
            ArrayList<JavaNonfinal> result = new ArrayList<JavaNonfinal>();
            List fields = unit.findAll(FieldDeclaration.class);
            for (Object field : fields) {
                if (field.isFinal()) continue;
                result.add(new JavaNonfinal((FieldDeclaration)field, (TypeDeclaration<?>)root));
            }
            List vars = unit.findAll(VariableDeclarationExpr.class);
            for (Object var : vars) {
                if (var.isFinal()) continue;
                result.add(new JavaNonfinal((VariableDeclarationExpr)var, (TypeDeclaration<?>)root));
            }
            List params = unit.findAll(Parameter.class);
            for (Parameter param : params) {
                if (param.isFinal()) continue;
                result.add(new JavaNonfinal(param, (TypeDeclaration<?>)root));
            }
            List types = unit.findAll(ClassOrInterfaceDeclaration.class);
            for (ClassOrInterfaceDeclaration type : types) {
                if (type.isInterface() || type.isFinal() || type.isAbstract()) continue;
                result.add(new JavaNonfinal(type, (TypeDeclaration<?>)root));
            }
            return result;
        }));
    }

    public JavaNonfinals(Violations<Nonfinal> statics) {
        this.statics = statics;
    }

    @Override
    public List<Nonfinal> asList() throws InspectionException {
        return this.statics.asList();
    }
}

