/*
 * Decompiled with CFR 0.152.
 */
package dev.youshallnotpass.inspections.allfinal;

import dev.youshallnotpass.inspection.ExcludeSuppressed;
import dev.youshallnotpass.inspection.InspectionException;
import dev.youshallnotpass.inspection.InspectionFailures;
import dev.youshallnotpass.inspection.SimpleViolations;
import dev.youshallnotpass.inspection.Violations;
import dev.youshallnotpass.inspection.badge.IwfyBadge;
import dev.youshallnotpass.inspection.sources.SourceMask;
import dev.youshallnotpass.inspections.allfinal.nonfinals.ExcludeCatchParams;
import dev.youshallnotpass.inspections.allfinal.nonfinals.ExcludeInterfaceMethodParams;
import dev.youshallnotpass.inspections.allfinal.nonfinals.ExcludeLambdaParams;
import dev.youshallnotpass.inspections.allfinal.nonfinals.JavaNonfinals;
import dev.youshallnotpass.inspections.allfinal.nonfinals.Nonfinal;
import dev.youshallnotpass.plugin.Failures;
import dev.youshallnotpass.plugin.Inspection;
import dev.youshallnotpass.plugin.IwfyException;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public final class Allfinal
implements Inspection {
    private final SourceMask sourceMask;
    private final int threshold;
    private final boolean skipInterfaceMethodParams;
    private final boolean skipLambdaParams;
    private final boolean skipCatchParams;
    private final List<Nonfinal> nonfinals;

    public Allfinal(SourceMask sourceMask, int threshold, boolean skipInterfaceMethodParams, boolean skipLambdaParams, boolean skipCatchParams) {
        this(sourceMask, threshold, skipInterfaceMethodParams, skipLambdaParams, skipCatchParams, new ArrayList<Nonfinal>());
    }

    public Allfinal(SourceMask sourceMask, int threshold, boolean skipInterfaceMethodParams, boolean skipLambdaParams, boolean skipCatchParams, List<Nonfinal> nonfinals) {
        this.sourceMask = sourceMask;
        this.threshold = threshold;
        this.skipInterfaceMethodParams = skipInterfaceMethodParams;
        this.skipLambdaParams = skipLambdaParams;
        this.skipCatchParams = skipCatchParams;
        this.nonfinals = nonfinals;
    }

    public String name() {
        return "allfinal";
    }

    public void accept(File file) throws IwfyException {
        Path path = file.toPath();
        if (this.sourceMask.matches(path)) {
            try {
                this.nonfinals.addAll(new JavaNonfinals(path.toFile()).asList());
            }
            catch (InspectionException e) {
                throw new IwfyException("Could not get the nulls.", (Throwable)e);
            }
        }
    }

    public Failures failures() {
        ExcludeSuppressed<Nonfinal> excludeSuppressed = new ExcludeSuppressed<Nonfinal>(new SimpleViolations<Nonfinal>(this.nonfinals));
        Violations<Nonfinal> excludeInterfaceMethodParams = this.skipInterfaceMethodParams ? new ExcludeInterfaceMethodParams(excludeSuppressed) : excludeSuppressed;
        Violations<Nonfinal> excludeLambdaParams = this.skipLambdaParams ? new ExcludeLambdaParams(excludeInterfaceMethodParams) : excludeInterfaceMethodParams;
        Violations<Nonfinal> excludeCatchParams = this.skipCatchParams ? new ExcludeCatchParams(excludeLambdaParams) : excludeLambdaParams;
        return new InspectionFailures<Nonfinal>(excludeCatchParams, new IwfyBadge(excludeCatchParams, this.threshold));
    }
}

