/*
 * Decompiled with CFR 0.152.
 */
package dev.youshallnotpass.inspection.badge;

import dev.youshallnotpass.inspection.InspectionException;
import dev.youshallnotpass.inspection.Violation;
import dev.youshallnotpass.inspection.Violations;
import dev.youshallnotpass.inspection.badge.Badge;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;

public final class IwfyBadge
implements Badge {
    private final Violations<? extends Violation> violations;
    private final int threshold;

    public IwfyBadge(Violations<? extends Violation> violations) {
        this(violations, 0);
    }

    public IwfyBadge(Violations<? extends Violation> violations, int threshold) {
        this.violations = violations;
        this.threshold = threshold;
    }

    @Override
    public void send(URL url) throws InspectionException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            ArrayList<BasicNameValuePair> form = new ArrayList<BasicNameValuePair>();
            for (Violation violation : this.violations.asList()) {
                form.add(new BasicNameValuePair("violation", violation.description()));
            }
            form.add(new BasicNameValuePair("threshold", String.valueOf(this.threshold)));
            HttpPost saveBadgeInfo = new HttpPost(url.toURI());
            saveBadgeInfo.setEntity((HttpEntity)new UrlEncodedFormEntity(form));
            httpClient.execute((HttpUriRequest)saveBadgeInfo).close();
        }
        catch (ClientProtocolException e) {
            throw new InspectionException("Static service error when sending badge info.", e);
        }
        catch (IOException | URISyntaxException e) {
            throw new InspectionException("Can not send the badge request.", e);
        }
    }

    @Override
    public void failIfRed() throws InspectionException {
        List<? extends Violation> violations = this.violations.asList();
        if (violations.size() > this.threshold) {
            StringBuilder message = new StringBuilder();
            for (Violation violation : violations) {
                message.append("Found:\n");
                message.append(violation.description());
                message.append('\n');
            }
            throw new InspectionException(String.format("Found statics:\n%s", message.toString()));
        }
    }
}

