/*
 * Decompiled with CFR 0.152.
 */
package dev.youshallnotpass.inspection;

import dev.youshallnotpass.inspection.InspectionException;
import dev.youshallnotpass.inspection.Violation;
import dev.youshallnotpass.inspection.Violations;
import dev.youshallnotpass.inspection.badge.Badge;
import dev.youshallnotpass.plugin.Failures;
import dev.youshallnotpass.plugin.IwfyException;
import dev.youshallnotpass.plugin.Ui;
import java.net.URL;

public final class InspectionFailures<T extends Violation>
implements Failures {
    private final Violations<T> nulls;
    private final Badge badge;

    public InspectionFailures(Violations<T> nulls, Badge badge) {
        this.nulls = nulls;
        this.badge = badge;
    }

    public void failIfRed() throws IwfyException {
        try {
            this.badge.failIfRed();
        }
        catch (InspectionException e) {
            throw new IwfyException("Inspection failed. ", (Throwable)e);
        }
    }

    public void show(Ui ui) throws IwfyException {
        try {
            for (Violation violation : this.nulls.asList()) {
                ui.println(violation.description());
            }
        }
        catch (InspectionException e) {
            throw new IwfyException("Could not show the violations.", (Throwable)e);
        }
    }

    public void publish(URL url) throws IwfyException {
        try {
            this.badge.send(url);
        }
        catch (InspectionException e) {
            throw new IwfyException("Could not publish the violations.", (Throwable)e);
        }
    }
}

