/*
 * Decompiled with CFR 0.152.
 */
package dev.yidafu.jupyper;

import dev.yidafu.jupyper.JavaScriptMagicCodeProcessor;
import dev.yidafu.jupyper.JsMagicMatcher;
import dev.yidafu.jupyper.processor.DefaultExportProcessor;
import dev.yidafu.jupyper.processor.ImportSourceMappingProcessor;
import dev.yidafu.jupyper.processor.JavascriptProcessContext;
import dev.yidafu.jupyper.processor.JupyterImportProcessor;
import dev.yidafu.swc.DslKt;
import dev.yidafu.swc.SwcNative;
import dev.yidafu.swc.TransformOutput;
import dev.yidafu.swc.booleanable.Booleanable;
import dev.yidafu.swc.dsl.OptionsKt;
import dev.yidafu.swc.types.EsParserConfig;
import dev.yidafu.swc.types.JscConfig;
import dev.yidafu.swc.types.Options;
import dev.yidafu.swc.types.ParserConfig;
import dev.yidafu.swc.types.Program;
import dev.yidafu.swc.types.TsParserConfig;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.CodePreprocessor;
import org.jetbrains.kotlinx.jupyter.api.KotlinKernelHost;
import org.jetbrains.kotlinx.jupyter.api.Notebook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u001eH\u0002J\u0010\u0010$\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u001eH\u0002J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u001eH\u0002J\u0010\u0010+\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u001eH\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\fR\u0014\u0010\u0019\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0016\u00a8\u0006,"}, d2={"Ldev/yidafu/jupyper/JavaScriptMagicCodeProcessor;", "Lorg/jetbrains/kotlinx/jupyter/api/CodePreprocessor;", "notebook", "Lorg/jetbrains/kotlinx/jupyter/api/Notebook;", "(Lorg/jetbrains/kotlinx/jupyter/api/Notebook;)V", "jsParseOpt", "Ldev/yidafu/swc/types/EsParserConfig;", "getJsParseOpt", "()Ldev/yidafu/swc/types/EsParserConfig;", "jsPrintOpt", "Ldev/yidafu/swc/types/Options;", "getJsPrintOpt", "()Ldev/yidafu/swc/types/Options;", "jsxParseOpt", "getJsxParseOpt", "log", "Lorg/slf4j/Logger;", "swcCompiler", "Ldev/yidafu/swc/SwcNative;", "tsParseOpt", "Ldev/yidafu/swc/types/TsParserConfig;", "getTsParseOpt", "()Ldev/yidafu/swc/types/TsParserConfig;", "tsPrintOpt", "getTsPrintOpt", "tsxParseOpt", "getTsxParseOpt", "accepts", "", "code", "", "executeJsProcessor", "Ldev/yidafu/jupyper/processor/JavascriptProcessContext;", "program", "Ldev/yidafu/swc/types/Program;", "source", "executeJsxProcessor", "process", "Lorg/jetbrains/kotlinx/jupyter/api/CodePreprocessor$Result;", "host", "Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelHost;", "processJsxCode", "processTsCode", "processTsxCode", "jupyter-js"})
public final class JavaScriptMagicCodeProcessor
implements CodePreprocessor {
    @NotNull
    private final Notebook notebook;
    @NotNull
    private final Logger log;
    @NotNull
    private final SwcNative swcCompiler;

    public JavaScriptMagicCodeProcessor(@NotNull Notebook notebook) {
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        this.notebook = notebook;
        Logger logger = LoggerFactory.getLogger(JavaScriptMagicCodeProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.log = logger;
        this.swcCompiler = new SwcNative();
    }

    public boolean accepts(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        JsMagicMatcher matcher = new JsMagicMatcher(code);
        return matcher.match() != JsMagicMatcher.LanguageType.Kotlin;
    }

    private final EsParserConfig getJsParseOpt() {
        return DslKt.esParseOptions((Function1)jsParseOpt.1.INSTANCE);
    }

    private final EsParserConfig getJsxParseOpt() {
        return DslKt.esParseOptions((Function1)jsxParseOpt.1.INSTANCE);
    }

    private final Options getJsPrintOpt() {
        return DslKt.options((Function1)((Function1)new Function1<Options, Unit>(this){
            final /* synthetic */ JavaScriptMagicCodeProcessor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Options $this$options) {
                Intrinsics.checkNotNullParameter((Object)$this$options, (String)"$this$options");
                $this$options.setJsc(OptionsKt.jscConfig((Options)$this$options, (Function1)((Function1)new Function1<JscConfig, Unit>(this.this$0){
                    final /* synthetic */ JavaScriptMagicCodeProcessor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull JscConfig $this$jscConfig) {
                        Intrinsics.checkNotNullParameter((Object)$this$jscConfig, (String)"$this$jscConfig");
                        $this$jscConfig.setTarget("es2020");
                        $this$jscConfig.setParser((ParserConfig)JavaScriptMagicCodeProcessor.access$getJsParseOpt(this.this$0));
                    }
                })));
            }
        }));
    }

    private final TsParserConfig getTsParseOpt() {
        return DslKt.tsParseOptions((Function1)tsParseOpt.1.INSTANCE);
    }

    private final Options getTsPrintOpt() {
        return DslKt.options((Function1)((Function1)new Function1<Options, Unit>(this){
            final /* synthetic */ JavaScriptMagicCodeProcessor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Options $this$options) {
                Intrinsics.checkNotNullParameter((Object)$this$options, (String)"$this$options");
                $this$options.setJsc(OptionsKt.jscConfig((Options)$this$options, (Function1)((Function1)new Function1<JscConfig, Unit>(this.this$0){
                    final /* synthetic */ JavaScriptMagicCodeProcessor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull JscConfig $this$jscConfig) {
                        Intrinsics.checkNotNullParameter((Object)$this$jscConfig, (String)"$this$jscConfig");
                        $this$jscConfig.setTarget("es2020");
                        $this$jscConfig.setParser((ParserConfig)JavaScriptMagicCodeProcessor.access$getTsParseOpt(this.this$0));
                    }
                })));
            }
        }));
    }

    private final TsParserConfig getTsxParseOpt() {
        return DslKt.tsParseOptions((Function1)tsxParseOpt.1.INSTANCE);
    }

    private final JavascriptProcessContext executeJsProcessor(Program program) {
        JavascriptProcessContext context = new JavascriptProcessContext();
        new JupyterImportProcessor(this.notebook).process(program, context);
        new ImportSourceMappingProcessor().process(program, context);
        return context;
    }

    private final JavascriptProcessContext executeJsxProcessor(Program program) {
        JavascriptProcessContext context = new JavascriptProcessContext();
        new JupyterImportProcessor(this.notebook).process(program, context);
        new ImportSourceMappingProcessor().process(program, context);
        new DefaultExportProcessor().process(program, context);
        return context;
    }

    private final String executeJsProcessor(String source) {
        Program program = this.swcCompiler.parseSync(source, (ParserConfig)this.getJsParseOpt(), "jupyter-cell.js");
        JavascriptProcessContext context = this.executeJsProcessor(program);
        TransformOutput output = this.swcCompiler.printSync(program, this.getJsPrintOpt());
        return "dev.yidafu.jupyper.JsCodeResult(\"\"\" " + context + "\n " + output.getCode() + " \"\"\")";
    }

    private final String processTsCode(String source) {
        TransformOutput transformOutput2 = this.swcCompiler.transformSync(source, false, DslKt.options((Function1)((Function1)new Function1<Options, Unit>(this){
            final /* synthetic */ JavaScriptMagicCodeProcessor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Options $this$options) {
                Intrinsics.checkNotNullParameter((Object)$this$options, (String)"$this$options");
                $this$options.setJsc(OptionsKt.jscConfig((Options)$this$options, (Function1)((Function1)new Function1<JscConfig, Unit>(this.this$0){
                    final /* synthetic */ JavaScriptMagicCodeProcessor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull JscConfig $this$jscConfig) {
                        Intrinsics.checkNotNullParameter((Object)$this$jscConfig, (String)"$this$jscConfig");
                        $this$jscConfig.setParser((ParserConfig)JavaScriptMagicCodeProcessor.access$getTsParseOpt(this.this$0));
                    }
                })));
            }
        })));
        Program program = this.swcCompiler.parseSync(transformOutput2.getCode(), (ParserConfig)this.getTsParseOpt(), "jupyter-cell-js.js");
        JavascriptProcessContext context = this.executeJsProcessor(program);
        TransformOutput output = this.swcCompiler.printSync(program, this.getTsPrintOpt());
        return "dev.yidafu.jupyper.JsCodeResult(\"\"\" " + context + "\n " + output.getCode() + " \"\"\")";
    }

    private final String processJsxCode(String source) {
        TransformOutput transformOutput2 = this.swcCompiler.transformSync(source, false, DslKt.options((Function1)((Function1)new Function1<Options, Unit>(this){
            final /* synthetic */ JavaScriptMagicCodeProcessor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Options $this$options) {
                Intrinsics.checkNotNullParameter((Object)$this$options, (String)"$this$options");
                $this$options.setJsc(OptionsKt.jscConfig((Options)$this$options, (Function1)((Function1)new Function1<JscConfig, Unit>(this.this$0){
                    final /* synthetic */ JavaScriptMagicCodeProcessor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull JscConfig $this$jscConfig) {
                        Intrinsics.checkNotNullParameter((Object)$this$jscConfig, (String)"$this$jscConfig");
                        $this$jscConfig.setParser((ParserConfig)JavaScriptMagicCodeProcessor.access$getJsxParseOpt(this.this$0));
                    }
                })));
                Booleanable.Companion this_$iv = Booleanable.Companion;
                boolean $i$f$ofTrue = false;
                $this$options.setModule(new Booleanable(null, Boolean.valueOf(true)));
            }
        })));
        Program program = this.swcCompiler.parseSync(transformOutput2.getCode(), (ParserConfig)this.getJsxParseOpt(), "jupyter-cell-jsx.js");
        JavascriptProcessContext context = this.executeJsxProcessor(program);
        TransformOutput output = this.swcCompiler.printSync(program, this.getJsPrintOpt());
        return "dev.yidafu.jupyper.JsxCodeResult(\"\"\" " + context + "\n " + output.getCode() + " \"\"\")";
    }

    private final String processTsxCode(String source) {
        TransformOutput transformOutput2 = this.swcCompiler.transformSync(source, false, DslKt.options((Function1)((Function1)new Function1<Options, Unit>(this){
            final /* synthetic */ JavaScriptMagicCodeProcessor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Options $this$options) {
                Intrinsics.checkNotNullParameter((Object)$this$options, (String)"$this$options");
                $this$options.setJsc(OptionsKt.jscConfig((Options)$this$options, (Function1)((Function1)new Function1<JscConfig, Unit>(this.this$0){
                    final /* synthetic */ JavaScriptMagicCodeProcessor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull JscConfig $this$jscConfig) {
                        Intrinsics.checkNotNullParameter((Object)$this$jscConfig, (String)"$this$jscConfig");
                        $this$jscConfig.setParser((ParserConfig)JavaScriptMagicCodeProcessor.access$getTsxParseOpt(this.this$0));
                    }
                })));
            }
        })));
        Program program = this.swcCompiler.parseSync(transformOutput2.getCode(), (ParserConfig)this.getTsxParseOpt(), "jupyter-cell-tsx.js");
        JavascriptProcessContext context = this.executeJsxProcessor(program);
        TransformOutput output = this.swcCompiler.printSync(program, this.getTsPrintOpt());
        return "dev.yidafu.jupyper.JsxCodeResult(\"\"\" " + context + "\n " + output.getCode() + " \"\"\")";
    }

    @NotNull
    public CodePreprocessor.Result process(@NotNull String code, @NotNull KotlinKernelHost host) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        JsMagicMatcher matcher = new JsMagicMatcher(code);
        JsMagicMatcher.LanguageType lang = matcher.match();
        this.log.info("process " + lang);
        String codeWithOutJs = matcher.getCleanSourceCode();
        try {
            object = switch (WhenMappings.$EnumSwitchMapping$0[lang.ordinal()]) {
                case 1 -> this.executeJsProcessor(codeWithOutJs);
                case 2 -> this.processTsCode(codeWithOutJs);
                case 3 -> this.processJsxCode(codeWithOutJs);
                case 4 -> this.processTsxCode(codeWithOutJs);
                case 5 -> codeWithOutJs;
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        catch (Exception e) {
            this.log.error("process js code fail", (Throwable)e);
            object = "org.jetbrains.kotlinx.jupyter.api.HTML(\"\"\"<code>" + e.getMessage() + "</code>\"\"\")";
        }
        String outputCode = object;
        return new CodePreprocessor.Result(outputCode, null, 2, null);
    }

    public static final /* synthetic */ EsParserConfig access$getJsParseOpt(JavaScriptMagicCodeProcessor $this) {
        return $this.getJsParseOpt();
    }

    public static final /* synthetic */ TsParserConfig access$getTsParseOpt(JavaScriptMagicCodeProcessor $this) {
        return $this.getTsParseOpt();
    }

    public static final /* synthetic */ EsParserConfig access$getJsxParseOpt(JavaScriptMagicCodeProcessor $this) {
        return $this.getJsxParseOpt();
    }

    public static final /* synthetic */ TsParserConfig access$getTsxParseOpt(JavaScriptMagicCodeProcessor $this) {
        return $this.getTsxParseOpt();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsMagicMatcher.LanguageType.values().length];
            try {
                nArray[JsMagicMatcher.LanguageType.JS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsMagicMatcher.LanguageType.TS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsMagicMatcher.LanguageType.JSX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsMagicMatcher.LanguageType.TSX.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsMagicMatcher.LanguageType.Kotlin.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

