package dev.yidafu.jupyper

import org.jetbrains.kotlinx.jupyter.api.DisplayResult
import org.jetbrains.kotlinx.jupyter.api.Notebook
import org.jetbrains.kotlinx.jupyter.api.Renderable
import org.jetbrains.kotlinx.jupyter.api.htmlResult

class ScriptImportMap(maps: Map<String, String>) : Map<String, String> by maps, Renderable {
    /**
     * Render to display result
     *
     * @param notebook Current notebook
     * @return Display result
     */
    override fun render(notebook: Notebook): DisplayResult {
        return htmlResult(
            """
            <script type="importmap" tag="jupyter-js">
                {"imports": {
                    ${this@ScriptImportMap.entries.joinToString(",\n") { "\"${it.key}\": \"${it.value}\"" }}
                }}
            </script>
        """.trimIndent(),
        )
    }
}

fun importmap(vararg maps: Pair<String, String>): ScriptImportMap = ScriptImportMap(mapOf(*maps))
