/*
 * Decompiled with CFR 0.152.
 */
package dev.yidafu.jupyper;

import dev.yidafu.jupyper.JavaScriptMagicCodeProcessor;
import dev.yidafu.jupyper.JsMagicMatcher;
import dev.yidafu.swc.DslKt;
import dev.yidafu.swc.SwcNative;
import dev.yidafu.swc.TransformOutput;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.CodePreprocessor;
import org.jetbrains.kotlinx.jupyter.api.KotlinKernelHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fJ\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fJ\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fR\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Ldev/yidafu/jupyper/JavaScriptMagicCodeProcessor;", "Lorg/jetbrains/kotlinx/jupyter/api/CodePreprocessor;", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "swcCompiler", "Ldev/yidafu/swc/SwcNative;", "getSwcCompiler", "()Ldev/yidafu/swc/SwcNative;", "accepts", "", "code", "", "process", "Lorg/jetbrains/kotlinx/jupyter/api/CodePreprocessor$Result;", "host", "Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelHost;", "processJsCode", "source", "processJsxCode", "processTsCode", "processTsxCode", "jupyter-js"})
public final class JavaScriptMagicCodeProcessor
implements CodePreprocessor {
    private final Logger log = LoggerFactory.getLogger(JavaScriptMagicCodeProcessor.class);
    @NotNull
    private final SwcNative swcCompiler = new SwcNative();

    public final Logger getLog() {
        return this.log;
    }

    @NotNull
    public final SwcNative getSwcCompiler() {
        return this.swcCompiler;
    }

    public boolean accepts(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        JsMagicMatcher matcher = new JsMagicMatcher(code);
        return matcher.match() != JsMagicMatcher.LanguageType.Kotlin;
    }

    @NotNull
    public final String processJsCode(@NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        TransformOutput output2 = this.swcCompiler.transformSync(source, false, DslKt.options((Function1)processJsCode.output.1.INSTANCE));
        return "dev.yidafu.jupyper.JsCodeResult(\"\"\"" + output2.getCode() + "\"\"\")";
    }

    @NotNull
    public final String processTsCode(@NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        TransformOutput output2 = this.swcCompiler.transformSync(source, false, DslKt.options((Function1)processTsCode.output.1.INSTANCE));
        return "dev.yidafu.jupyper.JsCodeResult(\"\"\"" + output2.getCode() + "\"\"\")";
    }

    @NotNull
    public final String processJsxCode(@NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        TransformOutput output2 = this.swcCompiler.transformSync(source, false, DslKt.options((Function1)processJsxCode.output.1.INSTANCE));
        return "dev.yidafu.jupyper.JsxCodeResult(\"\"\"" + output2.getCode() + "\"\"\")";
    }

    @NotNull
    public final String processTsxCode(@NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        TransformOutput output2 = this.swcCompiler.transformSync(source, false, DslKt.options((Function1)processTsxCode.output.1.INSTANCE));
        return "dev.yidafu.jupyper.JsxCodeResult(\"\"\"" + output2.getCode() + "\"\"\")";
    }

    @NotNull
    public CodePreprocessor.Result process(@NotNull String code, @NotNull KotlinKernelHost host) {
        String string;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        JsMagicMatcher matcher = new JsMagicMatcher(code);
        JsMagicMatcher.LanguageType lang = matcher.match();
        this.log.info("process " + lang);
        String codeWithOutJs = matcher.getSourceWithoutJsMagic();
        try {
            string = switch (WhenMappings.$EnumSwitchMapping$0[lang.ordinal()]) {
                case 1 -> this.processJsCode(codeWithOutJs);
                case 2 -> this.processJsxCode(codeWithOutJs);
                case 3 -> this.processTsCode(codeWithOutJs);
                case 4 -> this.processTsxCode(codeWithOutJs);
                case 5 -> codeWithOutJs;
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        catch (Exception e) {
            System.out.println(e);
            this.log.error("process js code fail", (Throwable)e);
            string = StringsKt.trimIndent((String)("\n            org.jetbrains.kotlinx.jupyter.api.HTML(\"<code>" + e.getMessage() + "</code>\")    \n            "));
        }
        String outputCode = string;
        return new CodePreprocessor.Result(outputCode, null, 2, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsMagicMatcher.LanguageType.values().length];
            try {
                nArray[JsMagicMatcher.LanguageType.JS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsMagicMatcher.LanguageType.JSX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsMagicMatcher.LanguageType.TS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsMagicMatcher.LanguageType.TSX.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsMagicMatcher.LanguageType.Kotlin.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

