/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.yavin.ws.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yahoo.elide.spring.config.ControllerProperties;
import com.yahoo.elide.spring.config.ElideConfigProperties;
import com.yahoo.elide.spring.config.JsonApiControllerProperties;
import com.yahoo.yavin.ws.config.DataSource;
import com.yahoo.yavin.ws.config.DataSourceTypes;
import com.yahoo.yavin.ws.config.UIFeatureSettings;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="ui")
@JsonSerialize(as=UIConfig.class)
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\u00128\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/yahoo/yavin/ws/config/UIConfig;", "", "elideSettings", "Lcom/yahoo/elide/spring/config/ElideConfigProperties;", "(Lcom/yahoo/elide/spring/config/ElideConfigProperties;)V", "appPersistence", "Lcom/yahoo/yavin/ws/config/DataSource;", "getAppPersistence", "()Lcom/yahoo/yavin/ws/config/DataSource;", "setAppPersistence", "(Lcom/yahoo/yavin/ws/config/DataSource;)V", "dataSources", "", "getDataSources", "()Ljava/util/List;", "setDataSources", "(Ljava/util/List;)V", "features", "Lcom/yahoo/yavin/ws/config/UIFeatureSettings;", "getFeatures", "()Lcom/yahoo/yavin/ws/config/UIFeatureSettings;", "setFeatures", "(Lcom/yahoo/yavin/ws/config/UIFeatureSettings;)V", "user", "", "getUser", "()Ljava/lang/String;", "setUser", "(Ljava/lang/String;)V", "ws"})
public class UIConfig {
    @NotNull
    private String user;
    @NotNull
    private List<DataSource> dataSources;
    @NotNull
    private DataSource appPersistence;
    @JsonProperty(value="FEATURES")
    @NotNull
    private UIFeatureSettings features;

    @NotNull
    public String getUser() {
        return this.user;
    }

    public void setUser(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.user = string;
    }

    @NotNull
    public List<DataSource> getDataSources() {
        return this.dataSources;
    }

    public void setDataSources(@NotNull List<DataSource> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.dataSources = list;
    }

    @NotNull
    public DataSource getAppPersistence() {
        return this.appPersistence;
    }

    public void setAppPersistence(@NotNull DataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"<set-?>");
        this.appPersistence = dataSource;
    }

    @NotNull
    public UIFeatureSettings getFeatures() {
        return this.features;
    }

    public void setFeatures(@NotNull UIFeatureSettings uIFeatureSettings) {
        Intrinsics.checkNotNullParameter((Object)uIFeatureSettings, (String)"<set-?>");
        this.features = uIFeatureSettings;
    }

    @Autowired
    public UIConfig(@NotNull ElideConfigProperties elideSettings) {
        Intrinsics.checkNotNullParameter((Object)elideSettings, (String)"elideSettings");
        this.user = "";
        ControllerProperties controllerProperties = elideSettings.getGraphql();
        Intrinsics.checkNotNullExpressionValue((Object)controllerProperties, (String)"elideSettings.graphql");
        String string = controllerProperties.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"elideSettings.graphql.path");
        this.dataSources = CollectionsKt.listOf((Object)new DataSource("default", string, DataSourceTypes.elide, 0, 8, null));
        JsonApiControllerProperties jsonApiControllerProperties = elideSettings.getJsonApi();
        Intrinsics.checkNotNullExpressionValue((Object)jsonApiControllerProperties, (String)"elideSettings.jsonApi");
        String string2 = jsonApiControllerProperties.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"elideSettings.jsonApi.path");
        this.appPersistence = new DataSource("persistence", string2, DataSourceTypes.elide, 0, 8, null);
        this.features = new UIFeatureSettings();
    }
}

