/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.gsheetjdbc.schema;

import com.yahoo.gsheetjdbc.schema.Column;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public final class Table {
    @NonNull
    private final String schema;
    @NonNull
    private final String tableName;
    @NonNull
    private final List<Column> columns;

    public Column getColumn(int idx) {
        return this.columns.get(idx);
    }

    Table(@NonNull String schema, @NonNull String tableName, @NonNull List<Column> columns) {
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        if (columns == null) {
            throw new NullPointerException("columns is marked non-null but is null");
        }
        this.schema = schema;
        this.tableName = tableName;
        this.columns = columns;
    }

    public static TableBuilder builder() {
        return new TableBuilder();
    }

    @NonNull
    public String getSchema() {
        return this.schema;
    }

    @NonNull
    public String getTableName() {
        return this.tableName;
    }

    @NonNull
    public List<Column> getColumns() {
        return this.columns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Table)) {
            return false;
        }
        Table other = (Table)o;
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        List<Column> this$columns = this.getColumns();
        List<Column> other$columns = other.getColumns();
        return !(this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        List<Column> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        return result;
    }

    public String toString() {
        return "Table(schema=" + this.getSchema() + ", tableName=" + this.getTableName() + ", columns=" + this.getColumns() + ")";
    }

    public static class TableBuilder {
        private String schema;
        private String tableName;
        private ArrayList<Column> columns;

        TableBuilder() {
        }

        public TableBuilder schema(@NonNull String schema) {
            if (schema == null) {
                throw new NullPointerException("schema is marked non-null but is null");
            }
            this.schema = schema;
            return this;
        }

        public TableBuilder tableName(@NonNull String tableName) {
            if (tableName == null) {
                throw new NullPointerException("tableName is marked non-null but is null");
            }
            this.tableName = tableName;
            return this;
        }

        public TableBuilder column(Column column) {
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.add(column);
            return this;
        }

        public TableBuilder columns(Collection<? extends Column> columns) {
            if (columns == null) {
                throw new NullPointerException("columns cannot be null");
            }
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.addAll(columns);
            return this;
        }

        public TableBuilder clearColumns() {
            if (this.columns != null) {
                this.columns.clear();
            }
            return this;
        }

        public Table build() {
            List<Column> columns;
            switch (this.columns == null ? 0 : this.columns.size()) {
                case 0: {
                    columns = Collections.emptyList();
                    break;
                }
                case 1: {
                    columns = Collections.singletonList(this.columns.get(0));
                    break;
                }
                default: {
                    columns = Collections.unmodifiableList(new ArrayList<Column>(this.columns));
                }
            }
            return new Table(this.schema, this.tableName, columns);
        }

        public String toString() {
            return "Table.TableBuilder(schema=" + this.schema + ", tableName=" + this.tableName + ", columns=" + this.columns + ")";
        }
    }
}

