/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.gsheetjdbc.schema;

import lombok.NonNull;

public final class Column {
    @NonNull
    private final ColumnType type;
    @NonNull
    private final String name;

    Column(@NonNull ColumnType type, @NonNull String name) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.type = type;
        this.name = name;
    }

    public static ColumnBuilder builder() {
        return new ColumnBuilder();
    }

    @NonNull
    public ColumnType getType() {
        return this.type;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column other = (Column)o;
        ColumnType this$type = this.getType();
        ColumnType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ColumnType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "Column(type=" + this.getType() + ", name=" + this.getName() + ")";
    }

    public static class ColumnBuilder {
        private ColumnType type;
        private String name;

        ColumnBuilder() {
        }

        public ColumnBuilder type(@NonNull ColumnType type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        public ColumnBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public Column build() {
            return new Column(this.type, this.name);
        }

        public String toString() {
            return "Column.ColumnBuilder(type=" + this.type + ", name=" + this.name + ")";
        }
    }

    public static enum ColumnType {
        DATE,
        DATETIME,
        STRING,
        BOOLEAN,
        NUMBER;

    }
}

