/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.gsheetjdbc.driver;

import com.yahoo.gsheetjdbc.data.CredentialFetcher;
import com.yahoo.gsheetjdbc.data.DataFetcher;
import com.yahoo.gsheetjdbc.data.GoogleServiceAccountCredentialFetcher;
import com.yahoo.gsheetjdbc.data.GoogleSheetsDataFetcher;
import com.yahoo.gsheetjdbc.driver.DocConfig;
import com.yahoo.gsheetjdbc.loader.DatabaseLoader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Driver
implements java.sql.Driver {
    private static final Logger log = LoggerFactory.getLogger(Driver.class);
    private static final String URL_PREFIX = "jdbc:gsheet:";
    private static final String DOC_ID_REGEX = "([a-zA-Z0-9-_]+)";
    private static final String SCHEMA_NAME_REGEX = "([a-zA-Z][a-zA-Z0-9_]*)";
    private static final String DOC_REGEX = "doc=\\(id=([a-zA-Z0-9-_]+),range=([^/!]+![a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+)\\)";
    private static final String URL_REGEX = "^jdbc:gsheet://doc=\\(id=([a-zA-Z0-9-_]+),range=([^/!]+![a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+)\\)((,doc=\\(id=([a-zA-Z0-9-_]+),range=([^/!]+![a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+)\\))*)/([a-zA-Z][a-zA-Z0-9_]*)$";
    private static final Pattern URL_PATTERN = Pattern.compile("^jdbc:gsheet://doc=\\(id=([a-zA-Z0-9-_]+),range=([^/!]+![a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+)\\)((,doc=\\(id=([a-zA-Z0-9-_]+),range=([^/!]+![a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+)\\))*)/([a-zA-Z][a-zA-Z0-9_]*)$");
    private static final Pattern DOC_PATTERN = Pattern.compile(",doc=\\(id=([a-zA-Z0-9-_]+),range=([^/!]+![a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+)\\)");
    Map<DocConfig, String> documents = new ConcurrentHashMap<DocConfig, String>();
    private final DatabaseLoader loader = new DatabaseLoader("gsheets");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        GoogleServiceAccountCredentialFetcher credentialFetcher = new GoogleServiceAccountCredentialFetcher();
        GoogleSheetsDataFetcher fetcher = new GoogleSheetsDataFetcher();
        Set<DocConfig> configs = Driver.parseUrl(url);
        Driver driver = this;
        synchronized (driver) {
            for (DocConfig config : configs) {
                String lastModified = fetcher.fetchLastUpdateTime(config.getId(), credentialFetcher);
                if (!this.documents.containsKey(config)) {
                    this.fetchAndLoad(config, credentialFetcher, this.loader);
                    this.documents.put(config, lastModified);
                    continue;
                }
                String previouslyModified = this.documents.get(config);
                if (previouslyModified != null && previouslyModified.equals(lastModified)) continue;
                this.fetchAndLoad(config, credentialFetcher, this.loader);
                this.documents.put(config, lastModified);
            }
            return this.loader.getConnection();
        }
    }

    private void fetchAndLoad(DocConfig document, CredentialFetcher credentialFetcher, DatabaseLoader loader) {
        GoogleSheetsDataFetcher fetcher = new GoogleSheetsDataFetcher();
        DataFetcher.Result result = fetcher.fetchDocumentSheet(credentialFetcher, document.getSchema(), document.getId(), document.getRange());
        try {
            loader.refreshTempTable(result.getSchema(), result.getData());
            loader.swapTables(result.getSchema());
        }
        catch (SQLException e) {
            log.error("Unable to reload table: {} {}", (Object)document, (Object)e.getMessage());
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            return false;
        }
        return url.startsWith(URL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    public static Set<DocConfig> parseUrl(String url) throws SQLException {
        Matcher urlMatcher = URL_PATTERN.matcher(url);
        if (!urlMatcher.find()) {
            throw new SQLException("Invalid JDBC URL : " + url);
        }
        int numberOfGroups = urlMatcher.groupCount();
        if (numberOfGroups != 7) {
            throw new SQLException("Invalid JDBC URL : " + url);
        }
        LinkedHashSet<DocConfig> results = new LinkedHashSet<DocConfig>();
        String schema = urlMatcher.group(numberOfGroups);
        String range = URLDecoder.decode(urlMatcher.group(2), Charset.defaultCharset());
        results.add(DocConfig.builder().schema(schema).range(range).id(urlMatcher.group(1)).build());
        Matcher idMatcher = DOC_PATTERN.matcher(urlMatcher.group(3));
        while (idMatcher.find()) {
            range = URLDecoder.decode(idMatcher.group(2), Charset.defaultCharset());
            results.add(DocConfig.builder().schema(schema).range(range).id(idMatcher.group(1)).build());
        }
        return results;
    }

    static {
        Driver driver = new Driver();
        try {
            DriverManager.registerDriver(driver);
        }
        catch (SQLException e) {
            log.error("Unable to register driver: " + e.getMessage());
            throw new IllegalStateException(e);
        }
    }
}

