/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.gsheetjdbc.data;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.DateTime;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.CellData;
import com.google.api.services.sheets.v4.model.ExtendedValue;
import com.google.api.services.sheets.v4.model.GridData;
import com.google.api.services.sheets.v4.model.NumberFormat;
import com.google.api.services.sheets.v4.model.RowData;
import com.google.api.services.sheets.v4.model.Sheet;
import com.google.api.services.sheets.v4.model.Spreadsheet;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.yahoo.gsheetjdbc.data.CredentialFetcher;
import com.yahoo.gsheetjdbc.data.DataFetcher;
import com.yahoo.gsheetjdbc.schema.Column;
import com.yahoo.gsheetjdbc.schema.Table;
import com.yahoo.gsheetjdbc.utils.DateUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleSheetsDataFetcher
implements DataFetcher {
    private static final Logger log = LoggerFactory.getLogger(GoogleSheetsDataFetcher.class);
    private static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private static final String APP_NAME = "GSheet JDBC Driver";
    private static final String LEGAL_NAME_REGEX = "^[ a-zA-Z0-9_-]+$";
    private static final Pattern LEGAL_NAME_PATTERN = Pattern.compile("^[ a-zA-Z0-9_-]+$");

    @Override
    public DataFetcher.Result fetchDocumentSheet(CredentialFetcher credentialFetcher, String schema, String document, String range) {
        try {
            Spreadsheet spreadsheet = this.fetchSpreadsheet(document, range, credentialFetcher);
            if (spreadsheet == null || spreadsheet.getSheets() == null || spreadsheet.getSheets().size() != 1) {
                String message = "No spreadsheets returned from server.";
                log.error(message);
                throw new IllegalStateException(message);
            }
            Sheet sheet = (Sheet)spreadsheet.getSheets().get(0);
            Table table = this.extractTableSchema(sheet, schema);
            List<List<Object>> data = this.extractSheetData(table, sheet);
            return DataFetcher.Result.builder().schema(table).data(data).build();
        }
        catch (IOException | GeneralSecurityException e) {
            log.error(e.getMessage());
            throw new IllegalStateException(e);
        }
    }

    public String fetchLastUpdateTime(String documentId, CredentialFetcher credentialFetcher) {
        try {
            NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
            Drive service = new Drive.Builder((HttpTransport)httpTransport, JSON_FACTORY, (HttpRequestInitializer)new HttpCredentialsAdapter((Credentials)credentialFetcher.getCredentials())).setApplicationName(APP_NAME).build();
            DateTime modifiedDate = ((File)service.files().get(documentId).setFields("modifiedTime").execute()).getModifiedTime();
            if (modifiedDate == null) {
                String message = "Server did not return document modification time";
                log.error(message);
                throw new IllegalStateException(message);
            }
            return modifiedDate.toString();
        }
        catch (IOException | GeneralSecurityException e) {
            log.error(e.getMessage());
            throw new IllegalStateException(e);
        }
    }

    Spreadsheet fetchSpreadsheet(String documentId, String range, CredentialFetcher credentialFetcher) throws IOException, GeneralSecurityException {
        NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        Sheets service = new Sheets.Builder((HttpTransport)httpTransport, JSON_FACTORY, (HttpRequestInitializer)new HttpCredentialsAdapter((Credentials)credentialFetcher.getCredentials())).setApplicationName(APP_NAME).build();
        Spreadsheet spreadsheet = (Spreadsheet)service.spreadsheets().get(documentId).setRanges(List.of(range)).setFields("sheets(data(rowData(values(effectiveValue,effectiveFormat(numberFormat)))),properties(title))").setIncludeGridData(Boolean.valueOf(true)).execute();
        return spreadsheet;
    }

    String extractTitle(Sheet sheet) {
        if (sheet.getProperties() == null || sheet.getProperties().getTitle() == null || sheet.getProperties().getTitle().isEmpty()) {
            String message = "Sheet title is missing or invalid title.";
            log.error(message);
            throw new IllegalStateException(message);
        }
        String title = sheet.getProperties().getTitle();
        Matcher matcher = LEGAL_NAME_PATTERN.matcher(title = title.substring(0, Math.min(256, title.length())));
        if (!matcher.matches()) {
            String message = "Sheet title must be a ASCII, Alphanumeric string.";
            log.error(message);
            throw new IllegalStateException(message);
        }
        return title;
    }

    String extractColumn(CellData headerCell) {
        if (headerCell.getEffectiveValue().getStringValue() == null || headerCell.getEffectiveValue().getStringValue().isEmpty()) {
            String message = "Header row must contain all string values.";
            log.error(message);
            throw new IllegalStateException(message);
        }
        String heading = headerCell.getEffectiveValue().getStringValue();
        Matcher matcher = LEGAL_NAME_PATTERN.matcher(heading = heading.substring(0, Math.min(256, heading.length())));
        if (!matcher.matches()) {
            String message = "Column heading must be a ASCII, Alphanumeric string.";
            log.error(message);
            throw new IllegalStateException(message);
        }
        return heading;
    }

    Table extractTableSchema(Sheet sheet, String schema) {
        Table table;
        if (sheet == null || sheet.getData() == null || sheet.getData().size() == 0 || sheet.getData().get(0) == null || ((GridData)sheet.getData().get(0)).getRowData() == null || ((GridData)sheet.getData().get(0)).getRowData().size() < 2) {
            String message = "Google sheets require at least two rows to determine the schema.";
            log.error(message);
            throw new IllegalStateException(message);
        }
        GridData gridData = (GridData)sheet.getData().get(0);
        String tableName = this.extractTitle(sheet);
        Table.TableBuilder schemaBuilder = Table.builder();
        schemaBuilder.tableName(tableName);
        schemaBuilder.schema(schema);
        int startRow = 0;
        int startColumn = 0;
        RowData headerRow = (RowData)gridData.getRowData().get(startRow);
        RowData firstDataRow = (RowData)gridData.getRowData().get(startRow + 1);
        for (int column = startColumn; column < headerRow.getValues().size(); ++column) {
            CellData headerCell = (CellData)headerRow.getValues().get(column);
            CellData dataCell = (CellData)firstDataRow.getValues().get(column);
            if (headerCell.getEffectiveValue() == null) break;
            String columnName = this.extractColumn(headerCell);
            schemaBuilder.column(Column.builder().name(columnName).type(this.extractColumnType(dataCell)).build());
        }
        if ((table = schemaBuilder.build()).getColumns().size() == 0) {
            String message = "Spreadsheet is missing header row starting at row 0.";
            log.error(message);
            throw new IllegalStateException(message);
        }
        return table;
    }

    List<List<Object>> extractSheetData(Table table, Sheet sheet) {
        int startRow;
        ArrayList<List<Object>> results = new ArrayList<List<Object>>();
        GridData gridData = (GridData)sheet.getData().get(0);
        for (int row = startRow = 1; row < gridData.getRowData().size(); ++row) {
            ArrayList<Object> rowResults = new ArrayList<Object>();
            RowData rowData = (RowData)gridData.getRowData().get(row);
            if (rowData.getValues().size() < table.getColumns().size()) break;
            int columnIndex = 0;
            for (Column column : table.getColumns()) {
                CellData cellData = (CellData)rowData.getValues().get(columnIndex);
                if (cellData.getEffectiveValue() == null) {
                    rowResults.add(null);
                } else {
                    rowResults.add(this.extractCellData(column, cellData));
                }
                ++columnIndex;
            }
            if (rowResults.stream().allMatch(obj -> obj == null)) break;
            results.add(rowResults);
        }
        return results;
    }

    Column.ColumnType extractColumnType(CellData cellData) {
        if (cellData.getEffectiveFormat() != null && cellData.getEffectiveFormat().getNumberFormat() != null) {
            NumberFormat numberFormat = cellData.getEffectiveFormat().getNumberFormat();
            if (numberFormat.getType().equals("DATE")) {
                return Column.ColumnType.DATE;
            }
            if (numberFormat.getType().equals("DATE_TIME")) {
                return Column.ColumnType.DATETIME;
            }
            return Column.ColumnType.NUMBER;
        }
        if (cellData.getEffectiveValue() != null) {
            ExtendedValue value = cellData.getEffectiveValue();
            if (value.getBoolValue() != null) {
                return Column.ColumnType.BOOLEAN;
            }
            if (value.getNumberValue() != null) {
                return Column.ColumnType.NUMBER;
            }
        }
        return Column.ColumnType.STRING;
    }

    Object extractCellData(Column column, CellData cellData) {
        Collection values = cellData.getEffectiveValue().values();
        if (values == null || values.size() != 1) {
            String message = String.format("Invalid value %s for column %s", cellData.getEffectiveValue(), column.getName());
            log.error(message);
            throw new IllegalStateException(message);
        }
        Object value = values.iterator().next();
        if (column.getType().equals((Object)Column.ColumnType.DATE) || column.getType().equals((Object)Column.ColumnType.DATETIME)) {
            return DateUtils.convert(value);
        }
        return value;
    }
}

