/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.gsheetjdbc.data;

import com.google.auth.oauth2.GoogleCredentials;
import com.yahoo.gsheetjdbc.data.CredentialFetcher;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class GoogleServiceAccountCredentialFetcher
implements CredentialFetcher {
    public static final String CREDENTIAL_ENVIRONMENT_VAR = "GSHEET_JDBC_CREDENTIALS";
    private final String credentialJson;

    public GoogleServiceAccountCredentialFetcher() {
        this(System.getenv(CREDENTIAL_ENVIRONMENT_VAR));
    }

    public GoogleServiceAccountCredentialFetcher(String credentialJson) {
        if (credentialJson == null || credentialJson.isEmpty()) {
            throw new IllegalArgumentException("GSHEET_JDBC_CREDENTIALS must be set as an environment variable with the correct credential JSON");
        }
        this.credentialJson = credentialJson;
    }

    @Override
    public GoogleCredentials getCredentials() throws IOException {
        return GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(this.credentialJson.getBytes())).createScoped(List.of("https://www.googleapis.com/auth/spreadsheets.readonly", "https://www.googleapis.com/auth/drive.metadata.readonly"));
    }
}

