/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.synthesis;

import dev.yasint.regexsynth.api.Expression;
import dev.yasint.regexsynth.api.MetaCharacters;
import dev.yasint.regexsynth.util.Common;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class TrieExpression
implements Expression {
    private static final String NULL_KEY = "";
    private final Node root = new Node();

    public void insert(String word) {
        Node current = this.root;
        for (int i = 0; i < word.length(); ++i) {
            String c = Character.toString(word.charAt(i));
            if (!current.containsKey(c)) {
                current.put(c, new Node());
            }
            current = current.get(c);
        }
        current.put(NULL_KEY, null);
    }

    public void insertAll(Collection<String> words) {
        for (String word : words) {
            this.insert(word);
        }
    }

    @Override
    public StringBuilder toRegex() {
        return this.root.toRegex();
    }

    private static final class Node
    implements Expression {
        private final Map<String, Node> nodes = new TreeMap<String, Node>();

        private Node() {
        }

        private boolean containsKey(String key) {
            return this.nodes.containsKey(key);
        }

        private void put(String c, Node node) {
            this.nodes.put(c, node);
        }

        private Node get(String _char) {
            return this.nodes.get(_char);
        }

        @Override
        public StringBuilder toRegex() {
            if (this.nodes.containsKey(TrieExpression.NULL_KEY) && this.nodes.size() == 1) {
                return null;
            }
            ArrayList<String> alternations = new ArrayList<String>();
            ArrayList<String> charClasses = new ArrayList<String>();
            boolean hasOptionals = false;
            for (Map.Entry<String, Node> entry : this.nodes.entrySet()) {
                String escaped = Common.asRegexLiteral(entry.getKey());
                if (entry.getValue() != null) {
                    StringBuilder subExpression = entry.getValue().toRegex();
                    if (subExpression != null) {
                        alternations.add((String)escaped + subExpression.toString());
                        continue;
                    }
                    charClasses.add(escaped);
                    continue;
                }
                hasOptionals = true;
            }
            boolean hasCharClass = alternations.isEmpty();
            if (charClasses.size() > 0) {
                if (charClasses.size() == 1) {
                    alternations.add((String)charClasses.get(0));
                } else {
                    StringBuilder set = new StringBuilder();
                    set.append(MetaCharacters.OPEN_SQUARE_BRACKET);
                    for (String it : charClasses) {
                        set.append(it);
                    }
                    set.append(MetaCharacters.CLOSE_SQUARE_BRACKET);
                    alternations.add(set.toString());
                }
            }
            StringBuilder expression = new StringBuilder();
            if (alternations.size() == 1) {
                expression.append((String)alternations.get(0));
            } else {
                expression.append(MetaCharacters.PAREN_OPEN).append(MetaCharacters.QUESTION_MARK).append(MetaCharacters.COLON);
                for (int i = 0; i < alternations.size(); ++i) {
                    expression.append((String)alternations.get(i));
                    if (i == alternations.size() - 1) continue;
                    expression.append("|");
                }
                expression.append(MetaCharacters.PAREN_CLOSE);
            }
            if (hasOptionals) {
                if (hasCharClass) {
                    return expression.append(MetaCharacters.QUESTION_MARK);
                }
                expression.insert(0, TrieExpression.NULL_KEY + MetaCharacters.PAREN_OPEN + MetaCharacters.QUESTION_MARK + MetaCharacters.COLON).append(MetaCharacters.PAREN_CLOSE).append(MetaCharacters.QUESTION_MARK);
                return expression;
            }
            return expression;
        }
    }
}

