/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.synthesis;

import com.google.re2j.Pattern;
import dev.yasint.regexsynth.api.Expression;
import dev.yasint.regexsynth.api.MetaCharacters;
import dev.yasint.regexsynth.dsl.Literals;
import dev.yasint.regexsynth.exceptions.InvalidCodepointException;
import dev.yasint.regexsynth.unicode.UnicodeScript;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class SetExpression
implements Expression {
    private static final Pattern SET_RESTRICTED = Pattern.compile((String)"[\\^\\]\\\\\\/\\-\"'`]");
    private Set<String> unicodeClasses;
    private Set<Integer> codepoints;
    private boolean negated;

    public SetExpression(boolean negated) {
        this.negated = negated;
        this.codepoints = new TreeSet<Integer>();
        this.unicodeClasses = new HashSet<String>();
    }

    public void negate() {
        this.negated = true;
    }

    public void addRange(int codepointA, int codepointB) {
        if (Character.isValidCodePoint(codepointA) && Character.isValidCodePoint(codepointB)) {
            if (codepointA > codepointB) {
                throw new InvalidCodepointException("character range is out of order");
            }
            if (codepointA == codepointB) {
                this.codepoints.add(codepointA);
                return;
            }
            for (int i = codepointA; i <= codepointB; ++i) {
                this.codepoints.add(i);
            }
        } else {
            throw new InvalidCodepointException("invalid codepoint");
        }
    }

    public void addChar(int codepoint) {
        if (!Character.isValidCodePoint(codepoint)) {
            throw new IllegalArgumentException("invalid codepoint");
        }
        this.codepoints.add(codepoint);
    }

    public SetExpression union(SetExpression b) {
        if (b.negated) {
            this.codepoints.removeAll(b.codepoints);
        } else {
            this.codepoints.addAll(b.codepoints);
        }
        return this;
    }

    public SetExpression intersection(SetExpression b) {
        if (b.negated) {
            this.codepoints.removeAll(b.codepoints);
        } else {
            this.codepoints.retainAll(b.codepoints);
        }
        return this;
    }

    public SetExpression difference(SetExpression b) {
        if (!b.negated) {
            b.negated = true;
        }
        this.intersection(b);
        return this;
    }

    public SetExpression withUnicodeClass(UnicodeScript block, boolean negated) {
        this.unicodeClasses.add(Literals.unicodeScriptLiteral(block, negated).toRegex().toString());
        return this;
    }

    @Override
    public StringBuilder toRegex() {
        Integer[] chars = this.codepoints.toArray(new Integer[0]);
        if (chars.length == 0 && this.unicodeClasses.isEmpty()) {
            return new StringBuilder(0);
        }
        if (chars.length == 0 && this.unicodeClasses.size() == 1 && !this.negated) {
            return new StringBuilder(this.unicodeClasses.iterator().next());
        }
        if (chars.length == 1 && !this.negated && this.unicodeClasses.isEmpty()) {
            return new StringBuilder().append(this.toRegexInterpretable(chars[0]));
        }
        StringBuilder expression = new StringBuilder();
        expression.append(MetaCharacters.OPEN_SQUARE_BRACKET);
        if (this.negated) {
            expression.append(MetaCharacters.CARAT);
        }
        int rangeStartIndex = -1;
        boolean isInRange = false;
        for (int curIndex = 0; curIndex < chars.length; ++curIndex) {
            if (curIndex + 1 < chars.length && chars[curIndex + 1] - chars[curIndex] == 1) {
                if (isInRange) continue;
                rangeStartIndex = curIndex;
                isInRange = true;
                continue;
            }
            if (isInRange) {
                if (curIndex - rangeStartIndex == 1) {
                    expression.append(this.toRegexInterpretable(chars[rangeStartIndex])).append(this.toRegexInterpretable(chars[curIndex]));
                } else {
                    expression.append(this.toRegexInterpretable(chars[rangeStartIndex])).append(MetaCharacters.HYPHEN).append(this.toRegexInterpretable(chars[curIndex]));
                }
                rangeStartIndex = -1;
                isInRange = false;
                continue;
            }
            expression.append(this.toRegexInterpretable(chars[curIndex]));
        }
        if (this.unicodeClasses.size() > 0) {
            for (String klass : this.unicodeClasses) {
                expression.append(klass);
            }
        }
        return expression.append(MetaCharacters.CLOSE_SQUARE_BRACKET);
    }

    private String toRegexInterpretable(int codepoint) {
        String c;
        if (Character.isISOControl(codepoint)) {
            return String.format("\\x%02X", codepoint);
        }
        if (Character.isSupplementaryCodePoint(codepoint)) {
            return String.format("\\x{%s}", Integer.toHexString(codepoint));
        }
        if (Character.isBmpCodePoint(codepoint) && SET_RESTRICTED.matches(c = Character.toString((char)codepoint))) {
            return MetaCharacters.BACKSLASH + c;
        }
        return Character.toString((char)codepoint);
    }
}

