/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.synthesis;

import dev.yasint.regexsynth.api.Expression;
import dev.yasint.regexsynth.api.MetaCharacters;
import java.util.Collections;
import java.util.LinkedList;

public class RangeExpression
implements Expression {
    private final int _rStart;
    private final int _rEnd;

    public RangeExpression(int _rStart, int _rEnd) {
        this._rStart = _rStart;
        this._rEnd = _rEnd;
    }

    private static LinkedList<Range> leftBounds(int start, int end) {
        LinkedList<Range> result = new LinkedList<Range>();
        while (start < end) {
            Range range = Range.fromStart(start);
            result.add(range);
            start = range.end + 1;
        }
        return result;
    }

    private static LinkedList<Range> rightBounds(int start, int end) {
        LinkedList<Range> result = new LinkedList<Range>();
        while (start < end) {
            Range range = Range.fromEnd(end);
            result.add(range);
            end = range.start - 1;
        }
        Collections.reverse(result);
        return result;
    }

    @Override
    public StringBuilder toRegex() {
        LinkedList<Range> left = RangeExpression.leftBounds(this._rStart, this._rEnd);
        Range lastLeft = left.removeLast();
        LinkedList<Range> right = RangeExpression.rightBounds(lastLeft.start, this._rEnd);
        Range firstRight = right.removeFirst();
        LinkedList<Range> merged = new LinkedList<Range>(left);
        if (!lastLeft.overlaps(firstRight)) {
            merged.add(lastLeft);
            merged.add(firstRight);
        } else {
            merged.add(Range.join(lastLeft, firstRight));
        }
        merged.addAll(right);
        StringBuilder expression = new StringBuilder();
        for (int i = merged.size() - 1; i >= 0; --i) {
            expression.append((CharSequence)merged.get(i).toRegex());
            if (i == 0) continue;
            expression.append("|");
        }
        return expression;
    }

    private static final class Range
    implements Expression {
        private int start;
        private int end;

        private Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        private static Range fromEnd(int end) {
            char[] chars = String.valueOf(end).toCharArray();
            for (int i = chars.length - 1; i >= 0; --i) {
                if (chars[i] != '9') {
                    chars[i] = 48;
                    break;
                }
                chars[i] = 48;
            }
            return new Range(Integer.parseInt(String.valueOf(chars)), end);
        }

        private static Range fromStart(int start) {
            char[] chars = String.valueOf(start).toCharArray();
            for (int i = chars.length - 1; i >= 0; --i) {
                if (chars[i] != '0') {
                    chars[i] = 57;
                    break;
                }
                chars[i] = 57;
            }
            return new Range(start, Integer.parseInt(String.valueOf(chars)));
        }

        private static Range join(Range a, Range b) {
            return new Range(a.start, b.end);
        }

        private boolean overlaps(Range r) {
            return this.end > r.start && r.end > this.start;
        }

        @Override
        public StringBuilder toRegex() {
            String startStr = String.valueOf(this.start);
            String endStr = String.valueOf(this.end);
            StringBuilder expression = new StringBuilder();
            int repeatedCount = 0;
            char previousDigitA = '\u0000';
            char previousDigitB = '\u0000';
            for (int pos = 0; pos < startStr.length(); ++pos) {
                char currentDigitB;
                char currentDigitA = startStr.charAt(pos);
                if (currentDigitA == (currentDigitB = endStr.charAt(pos))) {
                    expression.append(currentDigitA);
                    continue;
                }
                if (previousDigitA == currentDigitA && previousDigitB == currentDigitB) {
                    ++repeatedCount;
                    if (pos != startStr.length() - 1) continue;
                    expression.append(MetaCharacters.OPEN_CURLY_BRACE).append(++repeatedCount).append(MetaCharacters.CLOSE_CURLY_BRACE);
                    break;
                }
                if (repeatedCount > 0) {
                    expression.append(MetaCharacters.OPEN_CURLY_BRACE).append(repeatedCount).append(MetaCharacters.CLOSE_CURLY_BRACE);
                    repeatedCount = 0;
                }
                expression.append(MetaCharacters.OPEN_SQUARE_BRACKET).append(currentDigitA).append(currentDigitB - currentDigitA == 1 ? "" : MetaCharacters.HYPHEN).append(currentDigitB).append(MetaCharacters.CLOSE_SQUARE_BRACKET);
                previousDigitA = currentDigitA;
                previousDigitB = currentDigitB;
            }
            return expression;
        }

        public String toString() {
            return String.format("RangeGen { start=%d, end=%d }", this.start, this.end);
        }
    }
}

