/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.dsl;

import dev.yasint.regexsynth.api.Expression;
import dev.yasint.regexsynth.api.MetaCharacters;
import dev.yasint.regexsynth.dsl.Groups;
import dev.yasint.regexsynth.exceptions.QuantifierException;
import java.util.Objects;

public final class Repetition {
    public static Expression oneOrMoreTimes(Expression expression) {
        if (expression instanceof GreedyQuantifier || expression instanceof ReluctantQuantifier) {
            throw new QuantifierException("cannot apply + because it's already quantified");
        }
        return () -> Groups.nonCaptureGroup(Objects.requireNonNull(expression)).toRegex().append(MetaCharacters.PLUS);
    }

    public static Expression zeroOrMoreTimes(Expression expression) {
        if (expression instanceof GreedyQuantifier || expression instanceof ReluctantQuantifier) {
            throw new QuantifierException("cannot apply * because it's already quantified");
        }
        return () -> Groups.nonCaptureGroup(Objects.requireNonNull(expression)).toRegex().append(MetaCharacters.ASTERISK);
    }

    public static Expression exactlyOrMoreTimes(int times, Expression expression) {
        if (expression instanceof GreedyQuantifier || expression instanceof ReluctantQuantifier) {
            throw new QuantifierException("cannot apply {n,} because it's already quantified");
        }
        if (times > 1000) {
            throw new QuantifierException("max repetition is 1000");
        }
        if (times == 0) {
            return Repetition.zeroOrMoreTimes(expression);
        }
        if (times == 1) {
            return Repetition.oneOrMoreTimes(expression);
        }
        return () -> Groups.nonCaptureGroup(Objects.requireNonNull(expression)).toRegex().append(MetaCharacters.OPEN_CURLY_BRACE).append(times).append(MetaCharacters.COMMA).append(MetaCharacters.CLOSE_CURLY_BRACE);
    }

    public static Expression optional(Expression expression) {
        if (expression instanceof GreedyQuantifier || expression instanceof ReluctantQuantifier) {
            throw new QuantifierException("cannot apply ? because it's already quantified");
        }
        return () -> Groups.nonCaptureGroup(Objects.requireNonNull(expression)).toRegex().append(MetaCharacters.QUESTION_MARK);
    }

    public static Expression exactly(int times, Expression expression) {
        if (expression instanceof GreedyQuantifier || expression instanceof ReluctantQuantifier) {
            throw new QuantifierException("cannot apply {n} because it's already quantified");
        }
        if (times == 0) {
            throw new QuantifierException("redundant sub-sequence");
        }
        if (times == 1) {
            throw new QuantifierException("redundant quantifier");
        }
        if (times > 1000) {
            throw new QuantifierException("max repetition is 1000");
        }
        return () -> Groups.nonCaptureGroup(Objects.requireNonNull(expression)).toRegex().append(MetaCharacters.OPEN_CURLY_BRACE).append(times).append(MetaCharacters.CLOSE_CURLY_BRACE);
    }

    public static Expression between(int m, int n, Expression expression) {
        if (expression instanceof GreedyQuantifier || expression instanceof ReluctantQuantifier) {
            throw new QuantifierException("cannot apply {m,n} because it's already quantified");
        }
        if (m > 1000 || n > 1000) {
            throw new QuantifierException("max repetition is {1,1000}");
        }
        if (m > n) {
            throw new QuantifierException("range is out of order");
        }
        if (m == 0 && n == 0) {
            throw new QuantifierException("redundant sub-sequence");
        }
        if (m == 0 && n == 1) {
            return Repetition.optional(expression);
        }
        if (m == 1 && n == 1) {
            return expression;
        }
        if (m == n) {
            return Repetition.exactly(m, expression);
        }
        return () -> Groups.nonCaptureGroup(Objects.requireNonNull(expression)).toRegex().append(MetaCharacters.OPEN_CURLY_BRACE).append(m).append(MetaCharacters.COMMA).append(n).append(MetaCharacters.CLOSE_CURLY_BRACE);
    }

    public static Expression lazy(Expression expression) {
        if (expression instanceof ReluctantQuantifier) {
            throw new QuantifierException("already marked as lazy");
        }
        if (!(expression instanceof GreedyQuantifier)) {
            throw new QuantifierException("must be a greedy quantifier");
        }
        return () -> expression.toRegex().append(MetaCharacters.QUESTION_MARK);
    }

    public static interface ReluctantQuantifier
    extends Expression {
    }

    public static interface GreedyQuantifier
    extends Expression {
    }
}

