/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.dsl;

import dev.yasint.regexsynth.api.Expression;
import dev.yasint.regexsynth.dsl.Groups;
import dev.yasint.regexsynth.synthesis.TrieExpression;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class Operators {
    public static Expression either(Expression ... expressions) {
        String alternations = Arrays.stream(Objects.requireNonNull(expressions)).map(Expression::toRegex).collect(Collectors.joining("|"));
        return Groups.nonCaptureGroup(() -> new StringBuilder(alternations));
    }

    public static Expression either(String ... strings) {
        return Operators.either(new HashSet<String>(Arrays.asList(strings)));
    }

    public static Expression either(Set<String> strings) {
        TrieExpression trie = new TrieExpression();
        trie.insertAll(strings);
        return trie;
    }

    public static Expression concat(Expression a, Expression b) {
        return () -> Objects.requireNonNull(a).toRegex().append((CharSequence)Objects.requireNonNull(b).toRegex());
    }

    public static Expression concat(Expression ... expressions) {
        return () -> Arrays.stream(Objects.requireNonNull(expressions)).map(Expression::toRegex).reduce(new StringBuilder(), StringBuilder::append);
    }
}

