/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.dsl;

import dev.yasint.regexsynth.api.Expression;
import dev.yasint.regexsynth.api.MetaCharacters;
import dev.yasint.regexsynth.dsl.CharClasses;
import dev.yasint.regexsynth.dsl.Groups;
import dev.yasint.regexsynth.dsl.Literals;
import dev.yasint.regexsynth.exceptions.NumericRangeException;
import dev.yasint.regexsynth.synthesis.RangeExpression;

public final class Numeric {
    public static Expression leadingZero(Expression another) {
        return Groups.nonCaptureGroup(() -> another.toRegex().insert(0, "0" + MetaCharacters.QUESTION_MARK));
    }

    public static Expression integerRange(int from, int to) {
        if (from > to) {
            throw new NumericRangeException("integer range is out of order");
        }
        if (from == to) {
            return Literals.literal(String.valueOf(from));
        }
        if (from >= 0 && to <= 9) {
            return CharClasses.rangedSet(String.valueOf(from), String.valueOf(to));
        }
        return Groups.nonCaptureGroup(new RangeExpression(from, to));
    }
}

