/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.dsl;

import dev.yasint.regexsynth.api.Expression;
import dev.yasint.regexsynth.api.MetaCharacters;
import dev.yasint.regexsynth.unicode.UnicodeScript;
import dev.yasint.regexsynth.util.Common;
import java.util.Objects;

public final class Literals {
    public static Expression literal(String literals) {
        return () -> new StringBuilder(Common.asRegexLiteral(Objects.requireNonNull(literals)));
    }

    public static Expression quotedLiteral(String literals) {
        return () -> new StringBuilder().append(MetaCharacters.QUOTE_START).append(Objects.requireNonNull(literals)).append(MetaCharacters.QUOTE_END);
    }

    public static Expression unicodeScriptLiteral(UnicodeScript block, boolean negated) {
        String blockName = Objects.requireNonNull(block).getBlock();
        StringBuilder expression = new StringBuilder();
        if (blockName.length() == 1) {
            expression.append(negated ? "\\P" : "\\p").append(blockName);
        } else {
            expression.append(negated ? "\\P" : "\\p").append(MetaCharacters.OPEN_CURLY_BRACE).append(blockName).append(MetaCharacters.CLOSE_CURLY_BRACE);
        }
        return () -> expression;
    }
}

