/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.dsl;

import dev.yasint.regexsynth.api.Expression;
import dev.yasint.regexsynth.api.MetaCharacters;
import dev.yasint.regexsynth.exceptions.GenericException;
import dev.yasint.regexsynth.exceptions.SetElementException;
import dev.yasint.regexsynth.synthesis.SetExpression;
import dev.yasint.regexsynth.unicode.UnicodeScript;
import dev.yasint.regexsynth.util.Common;
import java.util.Objects;

public final class CharClasses {
    public static Expression anything() {
        return CharClasses.simpleSet(MetaCharacters.PERIOD.charValue());
    }

    public static Expression negated(Expression set) {
        if (Common.isNotASetExpression(set)) {
            throw new GenericException("must be a set expression");
        }
        ((SetExpression)set).negate();
        return set;
    }

    public static Expression union(Expression setA, Expression setB) {
        if (Common.isNotASetExpression(setA) || Common.isNotASetExpression(setB)) {
            throw new GenericException("union only supported for set expressions");
        }
        return ((SetExpression)setA).union((SetExpression)setB);
    }

    public static Expression difference(Expression setA, Expression setB) {
        if (Common.isNotASetExpression(setA) || Common.isNotASetExpression(setB)) {
            throw new GenericException("difference only supported for set expressions");
        }
        return ((SetExpression)setA).difference((SetExpression)setB);
    }

    public static Expression intersection(Expression setA, Expression setB) {
        if (Common.isNotASetExpression(setA) || Common.isNotASetExpression(setB)) {
            throw new GenericException("intersection only supported for set expressions");
        }
        return ((SetExpression)setA).intersection((SetExpression)setB);
    }

    public static Expression includeUnicodeScript(Expression set, UnicodeScript script, boolean negated) {
        if (Common.isNotASetExpression(set)) {
            throw new GenericException("includeUnicodeScript only supported for set expressions");
        }
        return ((SetExpression)set).withUnicodeClass(script, negated);
    }

    public static Expression rangedSet(String from, String to) {
        if (from == null || to == null) {
            throw new SetElementException("set range elements cannot be null");
        }
        SetExpression set = new SetExpression(false);
        set.addRange(Common.toCodepoint(from), Common.toCodepoint(to));
        return set;
    }

    public static Expression rangedSet(int codepointA, int codepointB) {
        SetExpression set = new SetExpression(false);
        set.addRange(codepointA, codepointB);
        return set;
    }

    public static Expression simpleSet(String ... characters) {
        SetExpression set = new SetExpression(false);
        for (String c : Objects.requireNonNull(characters)) {
            if (c.length() > 2) {
                throw new SetElementException("expected bmp or astral codepoint");
            }
            set.addChar(Common.toCodepoint(c));
        }
        return set;
    }

    public static Expression simpleSet(int ... codepoints) {
        SetExpression set = new SetExpression(false);
        for (int c : Objects.requireNonNull(codepoints)) {
            set.addChar(c);
        }
        return set;
    }

    public static Expression emptySet() {
        return new SetExpression(false);
    }

    public static class EscapeSequences {
        public static Expression space() {
            return CharClasses.simpleSet(" ");
        }

        public static Expression backslash() {
            return CharClasses.simpleSet("\\");
        }

        public static Expression doubleQuotes() {
            return CharClasses.simpleSet("\"");
        }

        public static Expression singleQuote() {
            return CharClasses.simpleSet("'");
        }

        public static Expression backtick() {
            return CharClasses.simpleSet("`");
        }

        public static Expression bell() {
            return CharClasses.simpleSet(7);
        }

        public static Expression horizontalTab() {
            return CharClasses.simpleSet(9);
        }

        public static Expression linebreak() {
            return CharClasses.simpleSet(10);
        }

        public static Expression verticalTab() {
            return CharClasses.simpleSet(11);
        }

        public static Expression formfeed() {
            return CharClasses.simpleSet(12);
        }

        public static Expression carriageReturn() {
            return CharClasses.simpleSet(13);
        }
    }

    public static class Posix {
        public static Expression lowercase() {
            return CharClasses.rangedSet("a", "z");
        }

        public static Expression uppercase() {
            return CharClasses.rangedSet("A", "Z");
        }

        public static Expression ascii() {
            return CharClasses.rangedSet(0, 127);
        }

        public static Expression ascii2() {
            return CharClasses.rangedSet(0, 255);
        }

        public static Expression alphabetic() {
            return CharClasses.union(Posix.lowercase(), Posix.uppercase());
        }

        public static Expression digit() {
            return CharClasses.rangedSet("0", "9");
        }

        public static Expression notDigit() {
            return CharClasses.negated(Posix.digit());
        }

        public static Expression alphanumeric() {
            return CharClasses.union(Posix.alphabetic(), Posix.digit());
        }

        public static Expression punctuation() {
            String elements = "!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";
            return CharClasses.simpleSet("!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~".split(""));
        }

        public static Expression graphical() {
            return CharClasses.union(Posix.alphanumeric(), Posix.punctuation());
        }

        public static Expression printable() {
            return CharClasses.union(Posix.graphical(), CharClasses.simpleSet(32));
        }

        public static Expression blank() {
            return CharClasses.simpleSet(9, 32);
        }

        public static Expression hexDigit() {
            return CharClasses.union(CharClasses.rangedSet("A", "F"), CharClasses.union(Posix.digit(), CharClasses.rangedSet("a", "f")));
        }

        public static Expression whitespace() {
            return CharClasses.simpleSet(32, 9, 10, 11, 12, 13);
        }

        public static Expression notWhitespace() {
            return CharClasses.negated(Posix.whitespace());
        }

        public static Expression word() {
            return CharClasses.union(Posix.alphanumeric(), CharClasses.simpleSet("_"));
        }

        public static Expression notWord() {
            return CharClasses.negated(Posix.word());
        }

        public static Expression control() {
            return CharClasses.union(CharClasses.rangedSet(0, 31), CharClasses.simpleSet(127));
        }
    }
}

