/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.dsl;

import dev.yasint.regexsynth.api.Expression;
import dev.yasint.regexsynth.api.MetaCharacters;
import java.util.Arrays;

public final class Anchors {
    public static Expression wordBoundary() {
        return () -> new StringBuilder(2).append(MetaCharacters.WORD_BOUNDARY);
    }

    public static Expression nonWordBoundary() {
        return () -> new StringBuilder(2).append(MetaCharacters.NON_WORD_BOUNDARY);
    }

    public static Expression startOfLine() {
        return () -> new StringBuilder(1).append(MetaCharacters.CARAT);
    }

    public static Expression endOfLine(boolean crlf) {
        return () -> new StringBuilder(6).append(crlf ? "\\x0D?" : "").append(MetaCharacters.DOLLAR);
    }

    public static Expression startOfText() {
        return () -> new StringBuilder(2).append(MetaCharacters.BEGINNING_OF_TEXT);
    }

    public static Expression endOfText() {
        return () -> new StringBuilder(2).append(MetaCharacters.END_OF_TEXT);
    }

    public static Expression exactLineMatch(Expression ... expressions) {
        return () -> Arrays.stream(expressions).map(Expression::toRegex).reduce(new StringBuilder().append(MetaCharacters.CARAT), StringBuilder::append).append(MetaCharacters.DOLLAR);
    }

    public static Expression exactWordBoundary(Expression ... expressions) {
        return () -> Arrays.stream(expressions).map(Expression::toRegex).reduce(new StringBuilder().append(MetaCharacters.WORD_BOUNDARY), StringBuilder::append).append(MetaCharacters.WORD_BOUNDARY);
    }
}

