/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.api;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import dev.yasint.regexsynth.api.Expression;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class RegexSynth {
    private String expression;
    private Pattern pattern;

    public RegexSynth(Expression ... expressions) {
        this.expression = Arrays.stream(expressions).map(Expression::toRegex).collect(Collectors.joining());
    }

    public static Map<Integer, String> getMatchedGroups(Matcher matcher) {
        HashMap<Integer, String> groups = new HashMap<Integer, String>();
        while (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                groups.put(i, matcher.group(i));
            }
        }
        return groups;
    }

    public RegexSynth compile(Flags ... flags) {
        int fl = 0;
        for (Flags flag : flags) {
            fl += flag.val;
        }
        this.pattern = Pattern.compile((String)this.expression, (int)fl);
        return this;
    }

    public Pattern getPattern() {
        if (this.pattern == null) {
            throw new NullPointerException("pattern instance is null. invoke compile(Flags...)");
        }
        return this.pattern;
    }

    public String getExpression() {
        return this.expression;
    }

    public static enum Flags {
        CASE_INSENSITIVE(1),
        MULTILINE(4),
        DOTALL(2);

        public final int val;

        private Flags(int val) {
            this.val = val;
        }
    }
}

