/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.util;

import dev.yasint.regexsynth.exceptions.InvalidGroupNameException;
import dev.yasint.regexsynth.util.Common;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class CommonTest {
    @Test
    public void itShouldEscapeAllSpecialConstructs() {
        Assertions.assertEquals((Object)Common.asRegexLiteral((String)"<"), (Object)"\\<");
        Assertions.assertEquals((Object)Common.asRegexLiteral((String)"("), (Object)"\\(");
        Assertions.assertEquals((Object)Common.asRegexLiteral((String)"["), (Object)"\\[");
        Assertions.assertEquals((Object)Common.asRegexLiteral((String)"{"), (Object)"\\{");
        Assertions.assertEquals((Object)Common.asRegexLiteral((String)"\\"), (Object)"\\\\");
        Assertions.assertEquals((Object)Common.asRegexLiteral((String)"^"), (Object)"\\^");
        Assertions.assertEquals((Object)Common.asRegexLiteral((String)"-"), (Object)"\\-");
        Assertions.assertEquals((Object)Common.asRegexLiteral((String)"="), (Object)"\\=");
        Assertions.assertEquals((Object)Common.asRegexLiteral((String)"$"), (Object)"\\$");
        Assertions.assertEquals((Object)Common.asRegexLiteral((String)"!"), (Object)"\\!");
        Assertions.assertEquals((Object)Common.asRegexLiteral((String)"|"), (Object)"\\|");
        Assertions.assertEquals((Object)Common.asRegexLiteral((String)"]"), (Object)"\\]");
        Assertions.assertEquals((Object)Common.asRegexLiteral((String)"}"), (Object)"\\}");
        Assertions.assertEquals((Object)Common.asRegexLiteral((String)")"), (Object)"\\)");
        Assertions.assertEquals((Object)Common.asRegexLiteral((String)"?"), (Object)"\\?");
        Assertions.assertEquals((Object)Common.asRegexLiteral((String)"*"), (Object)"\\*");
        Assertions.assertEquals((Object)Common.asRegexLiteral((String)"+"), (Object)"\\+");
        Assertions.assertEquals((Object)Common.asRegexLiteral((String)"."), (Object)"\\.");
        Assertions.assertEquals((Object)Common.asRegexLiteral((String)">"), (Object)"\\>");
        Assertions.assertEquals((Object)Common.asRegexLiteral((String)"/"), (Object)"\\/");
    }

    @Test
    public void itShouldThrowExceptionsForInvalidGroupNames() {
        Assertions.assertThrows(InvalidGroupNameException.class, () -> Common.asRegexGroupName((String)"--wowVeryWrong"));
        Assertions.assertThrows(InvalidGroupNameException.class, () -> Common.asRegexGroupName((String)"1wowVeryWrong"));
        Assertions.assertThrows(InvalidGroupNameException.class, () -> Common.asRegexGroupName((String)"+wowVeryWrong"));
    }
}

