/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.synthesis;

import com.google.re2j.Pattern;
import dev.yasint.regexsynth.api.Expression;
import dev.yasint.regexsynth.api.RegexSynth;
import dev.yasint.regexsynth.dsl.CharClasses;
import dev.yasint.regexsynth.unicode.UnicodeScript;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class SetExpressionTest {
    @Test
    public void itShouldCreateANonNegatedCharacterClass() {
        Expression simpleSet = CharClasses.simpleSet((String[])new String[]{"A", "B", "D", "E", "C"});
        Assertions.assertEquals((Object)simpleSet.toRegex().toString(), (Object)"[A-E]");
    }

    @Test
    public void itShouldCreateANegatedCharacterClass() {
        Expression simpleSet = CharClasses.negated((Expression)CharClasses.simpleSet((String[])new String[]{"a", "b", "c", "d", "Z"}));
        Assertions.assertEquals((Object)simpleSet.toRegex().toString(), (Object)"[^Za-d]");
    }

    @Test
    public void itShouldCreateASimpleCharacterClassWithoutRanges() {
        Expression simpleSet = CharClasses.simpleSet((String[])new String[]{"a", "d", "f", "h", "Z"});
        Assertions.assertEquals((Object)simpleSet.toRegex().toString(), (Object)"[Zadfh]");
    }

    @Test
    public void itShouldDoASetUnionOperationOnTwoSets() {
        Expression set = CharClasses.union((Expression)CharClasses.rangedSet((String)"A", (String)"Z"), (Expression)CharClasses.simpleSet((String[])new String[]{"a", "d", "f", "h", "Z"}));
        Assertions.assertEquals((Object)set.toRegex().toString(), (Object)"[A-Zadfh]");
    }

    @Test
    public void itShouldDoASetIntersectionOperationOnTwoSets() {
        Assertions.assertEquals((Object)CharClasses.intersection((Expression)CharClasses.union((Expression)CharClasses.rangedSet((String)"A", (String)"Z"), (Expression)CharClasses.rangedSet((String)"a", (String)"z")), (Expression)CharClasses.simpleSet((String[])new String[]{"d", "e", "f"})).toRegex().toString(), (Object)"[d-f]");
    }

    @Test
    public void itShouldDoADifferenceOperationOnTwoSets() {
        Expression setA = CharClasses.union((Expression)CharClasses.rangedSet((String)"A", (String)"Z"), (Expression)CharClasses.rangedSet((String)"a", (String)"z"));
        Expression setB = CharClasses.union((Expression)CharClasses.rangedSet((String)"M", (String)"P"), (Expression)CharClasses.rangedSet((String)"m", (String)"p"));
        Assertions.assertEquals((Object)CharClasses.difference((Expression)setA, (Expression)setB).toRegex().toString(), (Object)"[A-LQ-Za-lq-z]");
    }

    @Test
    public void itShouldDoASetUnionOperationOnInlineRegex() {
        Pattern expression = new RegexSynth(new Expression[]{CharClasses.union((Expression)CharClasses.rangedSet((String)"1", (String)"3"), (Expression)CharClasses.rangedSet((String)"4", (String)"6"))}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"[1-6]");
    }

    @Test
    public void itShouldDoASetIntersectionOperationOnInlineRegex() {
        Pattern expression = new RegexSynth(new Expression[]{CharClasses.intersection((Expression)CharClasses.rangedSet((String)"1", (String)"3"), (Expression)CharClasses.rangedSet((String)"4", (String)"6"))}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"");
    }

    @Test
    public void itShouldDoASetDifferenceOperationOnInlineRegex() {
        Pattern expression = new RegexSynth(new Expression[]{CharClasses.difference((Expression)CharClasses.rangedSet((String)"1", (String)"3"), (Expression)CharClasses.simpleSet((String[])new String[]{"2", "4", "5", "6"}))}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"[13]");
    }

    @Test
    public void itShouldAppendANonNegatedUnicodeClassesToASetExpression() {
        Pattern expression = new RegexSynth(new Expression[]{CharClasses.includeUnicodeScript((Expression)CharClasses.simpleSet((String[])new String[]{"-", "."}), (UnicodeScript)UnicodeScript.SINHALA, (boolean)false)}).compile(new RegexSynth.Flags[0]).getPattern();
        System.out.println(expression.pattern());
        Assertions.assertEquals((Object)expression.pattern(), (Object)"[\\-.\\p{Sinhala}]");
    }

    @Test
    public void itShouldAppendANegatedUnicodeClassesToASetExpression() {
        Pattern expression = new RegexSynth(new Expression[]{CharClasses.includeUnicodeScript((Expression)CharClasses.simpleSet((String[])new String[]{"-", "."}), (UnicodeScript)UnicodeScript.SINHALA, (boolean)true)}).compile(new RegexSynth.Flags[0]).getPattern();
        System.out.println(expression.pattern());
        Assertions.assertEquals((Object)expression.pattern(), (Object)"[\\-.\\P{Sinhala}]");
    }
}

