/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.examples;

import com.google.re2j.Pattern;
import dev.yasint.regexsynth.api.Expression;
import dev.yasint.regexsynth.api.RegexSynth;
import dev.yasint.regexsynth.dsl.Anchors;
import dev.yasint.regexsynth.dsl.CharClasses;
import dev.yasint.regexsynth.dsl.Groups;
import dev.yasint.regexsynth.dsl.Literals;
import dev.yasint.regexsynth.dsl.Numeric;
import dev.yasint.regexsynth.dsl.Operators;
import dev.yasint.regexsynth.dsl.Repetition;
import dev.yasint.regexsynth.unicode.UnicodeScript;
import java.time.Year;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class ExampleTest {
    public static Expression higherOrderFunc(Expression anotherFunc) {
        return () -> anotherFunc.toRegex().append("world!");
    }

    @Test
    public void powerOfExpressionInterface() {
        Expression e = ExampleTest.higherOrderFunc(() -> new StringBuilder("Hello "));
        Assertions.assertEquals((Object)e.toRegex().toString(), (Object)"Hello world!");
    }

    @Test
    public void randomTests() {
        Expression e = CharClasses.includeUnicodeScript((Expression)CharClasses.emptySet(), (UnicodeScript)UnicodeScript.ARABIC, (boolean)false);
        System.out.println(e.toRegex());
    }

    @Test
    public void complexExpressionSegregationExample() {
        Expression DATE = Groups.captureGroup((Expression[])new Expression[]{Numeric.integerRange((int)2010, (int)2020), Literals.literal((String)"-"), Numeric.leadingZero((Expression)Numeric.integerRange((int)1, (int)12)), Literals.literal((String)"-"), Numeric.leadingZero((Expression)Numeric.integerRange((int)1, (int)31))});
        Expression DEPT_CODE = Groups.captureGroup((Expression[])new Expression[]{Operators.either((String[])new String[]{"SO", "SS", "PE", "PA", "SSE"})});
        Expression ITEM_CODE = Groups.captureGroup((Expression[])new Expression[]{Numeric.integerRange((int)58499, (int)68599)});
        Expression ITEM_S_COUNT = Groups.captureGroup((Expression[])new Expression[]{Repetition.oneOrMoreTimes((Expression)CharClasses.Posix.digit())});
        Expression DELIMITER = CharClasses.EscapeSequences.space();
        Pattern pattern = new RegexSynth(new Expression[]{DATE, DELIMITER, DEPT_CODE, DELIMITER, ITEM_CODE, DELIMITER, ITEM_S_COUNT}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)pattern.pattern(), (Object)"((?:2020|201[0-9])\\-(?:0?(?:1[0-2]|[1-9]))\\-(?:0?(?:3[01]|[12][0-9]|[1-9]))) ((?:P[AE]|S(?:SE?|O))) ((?:68[0-5][0-9]{2}|6[0-7][0-9]{3}|59[0-9]{3}|58[5-9][0-9]{2}|58499)) ((?:[0-9])+)");
    }

    @Test
    public void simpleExpressionSegregationExample() {
        Expression DEPARTMENT_CODE = Groups.captureGroup((Expression[])new Expression[]{Operators.either((String[])new String[]{"K", "KS", "KLE", "KLL"})});
        Expression ITEM_STOCK_COUNT = Groups.captureGroup((Expression[])new Expression[]{Repetition.exactly((int)3, (Expression)CharClasses.Posix.digit())});
        Expression DATE = Groups.captureGroup((Expression[])new Expression[]{Repetition.exactly((int)4, (Expression)CharClasses.Posix.digit()), Literals.literal((String)"-"), Repetition.exactly((int)2, (Expression)CharClasses.Posix.digit()), Literals.literal((String)"-"), Repetition.exactly((int)2, (Expression)CharClasses.Posix.digit())});
        Expression DELIMITER = Literals.literal((String)"**");
        Pattern expression = new RegexSynth(new Expression[]{DEPARTMENT_CODE, DELIMITER, ITEM_STOCK_COUNT, DELIMITER, DATE}).compile(new RegexSynth.Flags[0]).getPattern();
        String expr = "(K(?:(?:L[EL]|S))?)\\*\\*([0-9]{3})\\*\\*([0-9]{4}\\-[0-9]{2}\\-[0-9]{2})";
    }

    @Test
    public void dateMatchingExample() {
        String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        Pattern expression = new RegexSynth(new Expression[]{Anchors.exactLineMatch((Expression[])new Expression[]{Numeric.integerRange((int)2012, (int)Year.now().getValue()), Literals.literal((String)"-"), Groups.captureGroup((Expression[])new Expression[]{Operators.either((String[])months)}), Literals.literal((String)"-"), Groups.captureGroup((Expression[])new Expression[]{Numeric.leadingZero((Expression)Numeric.integerRange((int)1, (int)31))})})}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"^(?:2020|201[2-9])\\-((?:A(?:pr|ug)|Dec|Feb|J(?:an|u[ln])|Ma[ry]|Nov|Oct|Sep))\\-((?:0?(?:3[01]|[12][0-9]|[1-9])))$");
    }

    @Test
    public void urlMatchingExample() {
        Expression protocol = Groups.namedCaptureGroup((String)"protocol", (Expression[])new Expression[]{Operators.either((String[])new String[]{"http", "https", "ftp"})});
        Expression sub_domain = Groups.namedCaptureGroup((String)"subDomain", (Expression[])new Expression[]{Repetition.oneOrMoreTimes((Expression)CharClasses.union((Expression)CharClasses.Posix.alphanumeric(), (Expression)CharClasses.simpleSet((String[])new String[]{"-", "."})))});
        Expression tld = Groups.namedCaptureGroup((String)"tld", (Expression[])new Expression[]{Repetition.between((int)2, (int)4, (Expression)CharClasses.Posix.alphabetic())});
        Expression port = Repetition.optional((Expression)Groups.namedCaptureGroup((String)"port", (Expression[])new Expression[]{Literals.literal((String)":"), Numeric.integerRange((int)1, (int)65535)}));
        Expression resource = Groups.namedCaptureGroup((String)"resource", (Expression[])new Expression[]{Repetition.zeroOrMoreTimes((Expression)CharClasses.anything())});
        Pattern expression = new RegexSynth(new Expression[]{Anchors.exactLineMatch((Expression[])new Expression[]{protocol, Literals.literal((String)"://"), sub_domain, Literals.literal((String)"."), tld, port, Repetition.optional((Expression)Literals.literal((String)"/")), resource})}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"^(?P<protocol>(?:ftp|https?)):\\/\\/(?P<subDomain>(?:[\\-.0-9A-Za-z])+)\\.(?P<tld>(?:[A-Za-z]){2,4})(?:(?P<port>:(?:6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{3}|[1-9][0-9]{2}|[1-9][0-9]|[1-9])))?(?:\\/)?(?P<resource>(?:.)*)$");
    }

    @Test
    public void doubleNumberMatchingExample() {
        Pattern pattern = new RegexSynth(new Expression[]{Anchors.exactWordBoundary((Expression[])new Expression[]{Numeric.integerRange((int)0, (int)1000), Literals.literal((String)"."), Repetition.between((int)1, (int)3, (Expression)CharClasses.Posix.digit())})}).compile(new RegexSynth.Flags[0]).getPattern();
        System.out.println(pattern.pattern());
    }
}

