/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.dsl;

import com.google.re2j.Pattern;
import dev.yasint.regexsynth.api.Expression;
import dev.yasint.regexsynth.api.RegexSynth;
import dev.yasint.regexsynth.dsl.CharClasses;
import dev.yasint.regexsynth.dsl.Repetition;
import dev.yasint.regexsynth.exceptions.QuantifierException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class RepetitionTest {
    @Test
    public void itShouldAppendOneOrMoreTimesQuantifierToExpression() {
        Pattern expression = new RegexSynth(new Expression[]{Repetition.oneOrMoreTimes((Expression)CharClasses.Posix.digit())}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"(?:[0-9])+");
    }

    @Test
    public void itShouldAppendZeroOrMoreTimesQuantifierToExpression() {
        Pattern expression = new RegexSynth(new Expression[]{Repetition.zeroOrMoreTimes((Expression)CharClasses.Posix.digit())}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"(?:[0-9])*");
    }

    @Test
    public void itShouldAppendExactlyOrMoreTimesQuantifierToExpression() {
        Pattern expression = new RegexSynth(new Expression[]{Repetition.exactlyOrMoreTimes((int)2, (Expression)CharClasses.Posix.digit())}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"(?:[0-9]){2,}");
        expression = new RegexSynth(new Expression[]{Repetition.exactlyOrMoreTimes((int)0, (Expression)CharClasses.Posix.digit())}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"(?:[0-9])*");
        expression = new RegexSynth(new Expression[]{Repetition.exactlyOrMoreTimes((int)1, (Expression)CharClasses.Posix.digit())}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"(?:[0-9])+");
    }

    @Test
    public void itShouldAppendOptionalQuantifierToExpression() {
        Pattern expression = new RegexSynth(new Expression[]{Repetition.optional((Expression)CharClasses.Posix.digit())}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"(?:[0-9])?");
    }

    @Test
    public void itShouldAppendExactlyNQuantifierToExpression() {
        Pattern expression = new RegexSynth(new Expression[]{Repetition.exactly((int)5, (Expression)CharClasses.Posix.digit())}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"(?:[0-9]){5}");
    }

    @Test
    public void itShouldAppendBetweenQuantifierToExpression() {
        Pattern expression = new RegexSynth(new Expression[]{Repetition.between((int)5, (int)10, (Expression)CharClasses.Posix.digit())}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"(?:[0-9]){5,10}");
    }

    @Test
    public void itShouldAppendLazyQuantifierToExpression() {
        Pattern expression = new RegexSynth(new Expression[]{Repetition.lazy((Expression)Repetition.between((int)5, (int)10, (Expression)CharClasses.Posix.digit()))}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"(?:[0-9]){5,10}?");
    }

    @Test
    public void itShouldNotAllowTwoFollowingQuantifiers() {
        Assertions.assertEquals((Object)((QuantifierException)Assertions.assertThrows(QuantifierException.class, () -> Repetition.zeroOrMoreTimes((Expression)Repetition.optional((Expression)CharClasses.Posix.digit())))).getMessage(), (Object)"cannot apply * because it's already quantified");
        Assertions.assertEquals((Object)((QuantifierException)Assertions.assertThrows(QuantifierException.class, () -> Repetition.oneOrMoreTimes((Expression)Repetition.zeroOrMoreTimes((Expression)CharClasses.Posix.digit())))).getMessage(), (Object)"cannot apply + because it's already quantified");
        Assertions.assertEquals((Object)((QuantifierException)Assertions.assertThrows(QuantifierException.class, () -> Repetition.exactlyOrMoreTimes((int)3, (Expression)Repetition.exactly((int)3, (Expression)CharClasses.Posix.digit())))).getMessage(), (Object)"cannot apply {n,} because it's already quantified");
        Assertions.assertEquals((Object)((QuantifierException)Assertions.assertThrows(QuantifierException.class, () -> Repetition.optional((Expression)Repetition.exactly((int)3, (Expression)CharClasses.Posix.digit())))).getMessage(), (Object)"cannot apply ? because it's already quantified");
        Assertions.assertEquals((Object)((QuantifierException)Assertions.assertThrows(QuantifierException.class, () -> Repetition.between((int)3, (int)6, (Expression)Repetition.exactly((int)5, (Expression)CharClasses.Posix.digit())))).getMessage(), (Object)"cannot apply {m,n} because it's already quantified");
    }

    @Test
    public void itShouldNotAppendLazyQuantifierIfGreedyQuantifierIsNotPresent() {
        Assertions.assertEquals((Object)((QuantifierException)Assertions.assertThrows(QuantifierException.class, () -> Repetition.lazy((Expression)CharClasses.Posix.digit()))).getMessage(), (Object)"must be a greedy quantifier");
    }

    @Test
    public void itShouldNotAppendLazyQuantifierIfItsAlreadyAppended() {
        Assertions.assertEquals((Object)((QuantifierException)Assertions.assertThrows(QuantifierException.class, () -> Repetition.lazy((Expression)Repetition.lazy((Expression)Repetition.optional((Expression)CharClasses.Posix.digit()))))).getMessage(), (Object)"already marked as lazy");
    }

    @Test
    public void itShouldNotAppendLazyQuantifierIfItsAlreadyAppended2() {
        Assertions.assertThrows(QuantifierException.class, () -> Repetition.oneOrMoreTimes((Expression)Repetition.lazy((Expression)Repetition.optional((Expression)CharClasses.Posix.digit()))));
        Assertions.assertThrows(QuantifierException.class, () -> Repetition.zeroOrMoreTimes((Expression)Repetition.lazy((Expression)Repetition.optional((Expression)CharClasses.Posix.digit()))));
        Assertions.assertThrows(QuantifierException.class, () -> Repetition.exactlyOrMoreTimes((int)4, (Expression)Repetition.lazy((Expression)Repetition.optional((Expression)CharClasses.Posix.digit()))));
        Assertions.assertThrows(QuantifierException.class, () -> Repetition.optional((Expression)Repetition.lazy((Expression)Repetition.optional((Expression)CharClasses.Posix.digit()))));
        Assertions.assertThrows(QuantifierException.class, () -> Repetition.exactly((int)2, (Expression)Repetition.lazy((Expression)Repetition.optional((Expression)CharClasses.Posix.digit()))));
        Assertions.assertThrows(QuantifierException.class, () -> Repetition.between((int)2, (int)4, (Expression)Repetition.lazy((Expression)Repetition.optional((Expression)CharClasses.Posix.digit()))));
    }

    @Test
    public void itShouldThrowAnExceptionWhenExactlyQuantifierIsRedundant() {
        Exception e = (Exception)Assertions.assertThrows(QuantifierException.class, () -> new RegexSynth(new Expression[]{Repetition.exactly((int)1, (Expression)CharClasses.Posix.digit())}).compile(new RegexSynth.Flags[0]));
        Assertions.assertEquals((Object)e.getMessage(), (Object)"redundant quantifier");
    }

    @Test
    public void itShouldThrowAnExceptionWhenExactlyQuantifierAppliedExpressionIsRedundant() {
        Exception e = (Exception)Assertions.assertThrows(QuantifierException.class, () -> new RegexSynth(new Expression[]{Repetition.exactly((int)0, (Expression)CharClasses.Posix.digit())}).compile(new RegexSynth.Flags[0]));
        Assertions.assertEquals((Object)e.getMessage(), (Object)"redundant sub-sequence");
    }
}

