/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.dsl;

import com.google.re2j.Pattern;
import dev.yasint.regexsynth.api.Expression;
import dev.yasint.regexsynth.api.RegexSynth;
import dev.yasint.regexsynth.dsl.CharClasses;
import dev.yasint.regexsynth.dsl.Operators;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class OperatorsTest {
    @Test
    public void itShouldCreateAlternationBetweenMultipleExpressions() {
        Pattern pattern = new RegexSynth(new Expression[]{Operators.either((Expression[])new Expression[]{CharClasses.Posix.digit(), CharClasses.Posix.uppercase(), CharClasses.Posix.lowercase()})}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)pattern.pattern(), (Object)"(?:[0-9]|[A-Z]|[a-z])");
    }

    @Test
    public void itShouldCreateAlternationBetweenMultipleStrings() {
        Pattern pattern = new RegexSynth(new Expression[]{Operators.either((String[])new String[]{"http", "https", "ws", "wss"})}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)pattern.pattern(), (Object)"(?:https?|wss?)");
    }

    @Test
    public void itShouldConcatMultipleExpressionsIntoOne() {
        Pattern pattern = new RegexSynth(new Expression[]{Operators.concat((Expression)CharClasses.Posix.digit(), (Expression)CharClasses.Posix.punctuation())}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)pattern.pattern(), (Object)"[0-9][!-\\/:-@[-\\`{-~]");
    }
}

