/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.dsl;

import dev.yasint.regexsynth.api.Expression;
import dev.yasint.regexsynth.dsl.Numeric;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class NumericTest {
    @Test
    public void itShouldHandleSmallIntegerRanges() {
        Assertions.assertEquals((Object)Numeric.integerRange((int)1, (int)10).toRegex().toString(), (Object)"(?:10|[1-9])");
        Assertions.assertEquals((Object)Numeric.integerRange((int)1, (int)100).toRegex().toString(), (Object)"(?:100|[1-9][0-9]|[1-9])");
    }

    @Test
    public void itShouldHandlePreciseIntegerCases() {
        Assertions.assertEquals((Object)Numeric.integerRange((int)1, (int)25675).toRegex().toString(), (Object)"(?:2567[0-5]|256[0-6][0-9]|25[0-5][0-9]{2}|2[0-4][0-9]{3}|1[0-9]{4}|[1-9][0-9]{3}|[1-9][0-9]{2}|[1-9][0-9]|[1-9])");
    }

    @Test
    public void itShouldHandleRelativelyLargeIntegers() {
        Expression expression = Numeric.integerRange((int)0, (int)999999999);
        Assertions.assertEquals((Object)expression.toRegex().toString(), (Object)"(?:[1-9][0-9]{8}|[1-9][0-9]{7}|[1-9][0-9]{6}|[1-9][0-9]{5}|[1-9][0-9]{4}|[1-9][0-9]{3}|[1-9][0-9]{2}|[1-9][0-9]|[0-9])");
    }

    @Test
    public void itShouldAddALeadingZeroToANumberOrARange() {
        Assertions.assertEquals((Object)Numeric.leadingZero((Expression)Numeric.integerRange((int)1, (int)12)).toRegex().toString(), (Object)"(?:0?(?:1[0-2]|[1-9]))");
    }
}

