/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.dsl;

import com.google.re2j.Pattern;
import dev.yasint.regexsynth.api.Expression;
import dev.yasint.regexsynth.api.RegexSynth;
import dev.yasint.regexsynth.dsl.Literals;
import dev.yasint.regexsynth.unicode.UnicodeScript;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class LiteralsTest {
    @Test
    public void itShouldEscapeAllSpecialCharacters() {
        Pattern pattern = new RegexSynth(new Expression[]{Literals.literal((String)"https://swtch.com/~rsc/regexp&id=1")}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)pattern.pattern(), (Object)"https:\\/\\/swtch\\.com\\/~rsc\\/regexp&id\\=1");
    }

    @Test
    public void itShouldCreateStrictQuoteString() {
        Pattern pattern = new RegexSynth(new Expression[]{Literals.quotedLiteral((String)"https://swtch.com/~rsc/regexp&id=1")}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)pattern.pattern(), (Object)"\\Qhttps://swtch.com/~rsc/regexp&id=1\\E");
    }

    @Test
    public void itShouldCreateANonNegatedUnicodeScriptBlock() {
        Pattern pattern = new RegexSynth(new Expression[]{Literals.unicodeScriptLiteral((UnicodeScript)UnicodeScript.SINHALA, (boolean)false)}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)pattern.pattern(), (Object)"\\p{Sinhala}");
    }

    @Test
    public void itShouldCreateANegatedUnicodeScriptBlock() {
        Pattern pattern = new RegexSynth(new Expression[]{Literals.unicodeScriptLiteral((UnicodeScript)UnicodeScript.ARMENIAN, (boolean)true)}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)pattern.pattern(), (Object)"\\P{Armenian}");
    }
}

