/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.dsl;

import com.google.re2j.Pattern;
import dev.yasint.regexsynth.api.Expression;
import dev.yasint.regexsynth.api.RegexSynth;
import dev.yasint.regexsynth.dsl.CharClasses;
import dev.yasint.regexsynth.dsl.Groups;
import dev.yasint.regexsynth.exceptions.InvalidGroupNameException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class GroupsTest {
    @Test
    public void itShouldCreateANonCapturingGroup() {
        Pattern pattern = new RegexSynth(new Expression[]{Groups.nonCaptureGroup((Expression[])new Expression[]{CharClasses.Posix.digit()})}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)pattern.pattern(), (Object)"(?:[0-9])");
    }

    @Test
    public void itShouldCreateACapturingGroup() {
        Pattern pattern = new RegexSynth(new Expression[]{Groups.nonCaptureGroup((Expression[])new Expression[]{CharClasses.union((Expression)CharClasses.Posix.digit(), (Expression)CharClasses.Posix.punctuation())})}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)pattern.pattern(), (Object)"(?:[!-@[-\\`{-~])");
    }

    @Test
    public void itShouldCreateANamedCaptureGroup() {
        Pattern pattern = new RegexSynth(new Expression[]{Groups.namedCaptureGroup((String)"someName", (Expression[])new Expression[]{CharClasses.union((Expression)CharClasses.Posix.word(), (Expression)CharClasses.Posix.punctuation())})}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)pattern.pattern(), (Object)"(?P<someName>[!-~])");
    }

    @Test
    public void itShouldThrowAnExceptionIfTheNamedCaptureGroupNameIsInvalid() {
        Assertions.assertThrows(InvalidGroupNameException.class, () -> Groups.namedCaptureGroup((String)"- 902 someName", (Expression[])new Expression[]{CharClasses.union((Expression)CharClasses.Posix.word(), (Expression)CharClasses.Posix.punctuation())}).toRegex());
    }
}

