/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.dsl;

import com.google.re2j.Pattern;
import dev.yasint.regexsynth.api.Expression;
import dev.yasint.regexsynth.api.RegexSynth;
import dev.yasint.regexsynth.dsl.CharClasses;
import dev.yasint.regexsynth.dsl.Repetition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class CharClassesTest {
    @Test
    public void itShouldAppendMatchAnyCharacterAtPosition() {
        Pattern expression = new RegexSynth(new Expression[]{Repetition.exactly((int)5, (Expression)CharClasses.anything())}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"(?:.){5}");
    }

    @Test
    public void itShouldCreateCorrectPOSIXLowerCaseCharClass() {
        Expression set = CharClasses.Posix.lowercase();
        Assertions.assertEquals((Object)set.toRegex().toString(), (Object)"[a-z]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXUpperCaseCharClass() {
        Expression set = CharClasses.Posix.uppercase();
        Assertions.assertEquals((Object)set.toRegex().toString(), (Object)"[A-Z]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXAlphabeticCharClass() {
        Expression set = CharClasses.Posix.alphabetic();
        Assertions.assertEquals((Object)set.toRegex().toString(), (Object)"[A-Za-z]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXDigitCharClass() {
        Expression set = CharClasses.Posix.digit();
        Assertions.assertEquals((Object)set.toRegex().toString(), (Object)"[0-9]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXNotDigitCharClass() {
        Expression set = CharClasses.Posix.notDigit();
        Assertions.assertEquals((Object)set.toRegex().toString(), (Object)"[^0-9]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXAlphanumericCharClass() {
        Expression set = CharClasses.Posix.alphanumeric();
        Assertions.assertEquals((Object)set.toRegex().toString(), (Object)"[0-9A-Za-z]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXPunctCharClass() {
        Expression set = CharClasses.Posix.punctuation();
        Assertions.assertEquals((Object)set.toRegex().toString(), (Object)"[!-\\/:-@[-\\`{-~]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXGraphCharClass() {
        Expression set = CharClasses.Posix.graphical();
        Assertions.assertEquals((Object)set.toRegex().toString(), (Object)"[!-~]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXPrintableCharClass() {
        Expression set = CharClasses.Posix.printable();
        Assertions.assertEquals((Object)set.toRegex().toString(), (Object)"[ -~]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXBlankCharClass() {
        Expression set = CharClasses.Posix.blank();
        Assertions.assertEquals((Object)set.toRegex().toString(), (Object)"[\\x09 ]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXHexDigitCharClass() {
        Expression set = CharClasses.Posix.hexDigit();
        Assertions.assertEquals((Object)set.toRegex().toString(), (Object)"[0-9A-Fa-f]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXWhitespaceCharClass() {
        Expression set = CharClasses.Posix.whitespace();
        Assertions.assertEquals((Object)set.toRegex().toString(), (Object)"[\\x09-\\x0D ]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXNonWhitespaceCharClass() {
        Expression set = CharClasses.Posix.notWhitespace();
        Assertions.assertEquals((Object)set.toRegex().toString(), (Object)"[^\\x09-\\x0D ]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXWordCharClass() {
        Expression set = CharClasses.Posix.word();
        Assertions.assertEquals((Object)set.toRegex().toString(), (Object)"[0-9A-Z_a-z]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXWorNotWordCharClass() {
        Expression set = CharClasses.Posix.notWord();
        Assertions.assertEquals((Object)set.toRegex().toString(), (Object)"[^0-9A-Z_a-z]");
    }

    @Test
    public void itShouldCreateCorrectPOSIXControlCharClass() {
        Expression set = CharClasses.Posix.control();
        Assertions.assertEquals((Object)set.toRegex().toString(), (Object)"[\\x00-\\x1F\\x7F]");
    }

    @Test
    public void itShouldReturnCorrectEscapeSequence() {
        Expression backslash = CharClasses.EscapeSequences.backslash();
        Expression doubleQuotes = CharClasses.EscapeSequences.doubleQuotes();
        Expression singleQuote = CharClasses.EscapeSequences.singleQuote();
        Expression backtick = CharClasses.EscapeSequences.backtick();
        Expression bell = CharClasses.EscapeSequences.bell();
        Expression horizontalTab = CharClasses.EscapeSequences.horizontalTab();
        Expression linebreak = CharClasses.EscapeSequences.linebreak();
        Expression verticalTab = CharClasses.EscapeSequences.verticalTab();
        Expression formfeed = CharClasses.EscapeSequences.formfeed();
        Expression carriageReturn = CharClasses.EscapeSequences.carriageReturn();
        Assertions.assertEquals((Object)backslash.toRegex().toString(), (Object)"\\\\");
        Assertions.assertEquals((Object)doubleQuotes.toRegex().toString(), (Object)"\\\"");
        Assertions.assertEquals((Object)singleQuote.toRegex().toString(), (Object)"\\'");
        Assertions.assertEquals((Object)backtick.toRegex().toString(), (Object)"\\`");
        Assertions.assertEquals((Object)bell.toRegex().toString(), (Object)"\\x07");
        Assertions.assertEquals((Object)horizontalTab.toRegex().toString(), (Object)"\\x09");
        Assertions.assertEquals((Object)linebreak.toRegex().toString(), (Object)"\\x0A");
        Assertions.assertEquals((Object)verticalTab.toRegex().toString(), (Object)"\\x0B");
        Assertions.assertEquals((Object)formfeed.toRegex().toString(), (Object)"\\x0C");
        Assertions.assertEquals((Object)carriageReturn.toRegex().toString(), (Object)"\\x0D");
    }

    @Test
    public void itShouldCreateAllAsciiCharClassRange() {
        Expression ascii = CharClasses.Posix.ascii();
        Assertions.assertEquals((Object)ascii.toRegex().toString(), (Object)"[\\x00-\\x7F]");
    }

    @Test
    public void itShouldCreateAllExtendedAsciiCharClassRange() {
        Expression ascii = CharClasses.Posix.ascii2();
        Assertions.assertEquals((Object)ascii.toRegex().toString(), (Object)"[\\x00-\u00ff]");
    }

    @Test
    public void itShouldCreateARangedCharClassWhenGivenTwoCodepoints() {
        String from = "\ud83c\udf11";
        String to = "\ud83c\udf1d";
        Expression regexSet = CharClasses.rangedSet((String)"\ud83c\udf11", (String)"\ud83c\udf1d");
        Assertions.assertEquals((Object)regexSet.toRegex().toString(), (Object)"[\\x{1f311}-\\x{1f31d}]");
    }
}

