/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.dsl;

import com.google.re2j.Pattern;
import dev.yasint.regexsynth.api.Expression;
import dev.yasint.regexsynth.api.RegexSynth;
import dev.yasint.regexsynth.dsl.Anchors;
import dev.yasint.regexsynth.dsl.CharClasses;
import dev.yasint.regexsynth.dsl.Groups;
import dev.yasint.regexsynth.dsl.Literals;
import dev.yasint.regexsynth.dsl.Repetition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class AnchorsTest {
    @Test
    public void itShouldAppendAWordBoundaryAtPosition() {
        Expression[] expressionArray = new Expression[1];
        Expression[] expressionArray2 = new Expression[2];
        expressionArray2[0] = Anchors.wordBoundary().debug(System.out::println);
        expressionArray2[1] = CharClasses.Posix.word();
        expressionArray[0] = Groups.captureGroup((Expression[])expressionArray2);
        Pattern expression = new RegexSynth(expressionArray).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"(\\b[0-9A-Z_a-z])");
    }

    @Test
    public void itShouldAppendANonWordBoundaryAtPosition() {
        Pattern expression = new RegexSynth(new Expression[]{Anchors.nonWordBoundary(), CharClasses.Posix.word()}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"\\B[0-9A-Z_a-z]");
    }

    @Test
    public void itShouldAppendAStartOfLineAssertionAtPosition() {
        Pattern expression = new RegexSynth(new Expression[]{Anchors.startOfLine(), CharClasses.Posix.word()}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"^[0-9A-Z_a-z]");
    }

    @Test
    public void itShouldAppendEndOfLineAssertionAtPosition() {
        Pattern expression = new RegexSynth(new Expression[]{Anchors.startOfLine(), Repetition.oneOrMoreTimes((Expression)CharClasses.Posix.word()), Anchors.endOfLine((boolean)false)}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"^(?:[0-9A-Z_a-z])+$");
    }

    @Test
    public void itShouldAppendEndOfLineAssertionWithOptionalCarriageReturnAtPosition() {
        Pattern expression = new RegexSynth(new Expression[]{Anchors.startOfLine(), Repetition.oneOrMoreTimes((Expression)CharClasses.Posix.word()), Anchors.endOfLine((boolean)true)}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"^(?:[0-9A-Z_a-z])+\\x0D?$");
    }

    @Test
    public void itShouldAppendStartOfTextAssertionAtPosition() {
        Pattern expression = new RegexSynth(new Expression[]{Anchors.startOfText(), CharClasses.Posix.word()}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"\\A[0-9A-Z_a-z]");
    }

    @Test
    public void itShouldAppendEndOfTextAssertionAtPosition() {
        Pattern expression = new RegexSynth(new Expression[]{CharClasses.Posix.word(), Anchors.endOfText()}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"[0-9A-Z_a-z]\\z");
    }

    @Test
    public void itShouldWrapTheExpressionInLineMatcher() {
        Pattern expression = new RegexSynth(new Expression[]{Anchors.exactLineMatch((Expression[])new Expression[]{Anchors.wordBoundary(), CharClasses.Posix.word()})}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"^\\b[0-9A-Z_a-z]$");
    }

    @Test
    public void itShouldWrapTheExpressionInWordBoundary() {
        Pattern expression = new RegexSynth(new Expression[]{Anchors.exactWordBoundary((Expression[])new Expression[]{Literals.literal((String)"p"), Repetition.oneOrMoreTimes((Expression)CharClasses.Posix.alphabetic()), Literals.literal((String)"p")})}).compile(new RegexSynth.Flags[0]).getPattern();
        Assertions.assertEquals((Object)expression.pattern(), (Object)"\\bp(?:[A-Za-z])+p\\b");
    }
}

