/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.core;

import com.google.re2j.Pattern;

public final class Utility {
    private static final Pattern VALID_GROUP_NAME = Pattern.compile((String)"^[^[:punct:][:digit:][:space:]]\\w{1,15}$");
    private static final Pattern RESERVED = Pattern.compile((String)"[<(\\[{\\\\^\\-=$!|\\]})?*+.>/]");

    public static String asRegexLiteral(String someString) {
        int codepoint = Utility.toCodepoint(someString);
        if (Character.isSupplementaryCodePoint(codepoint)) {
            return String.format("\\x{%s}", Integer.toHexString(codepoint));
        }
        return RESERVED.matcher((CharSequence)someString).replaceAll("\\\\$0");
    }

    public static String asRegexGroupName(String name) {
        boolean valid = VALID_GROUP_NAME.matcher((CharSequence)name).matches();
        if (!valid) {
            throw new RuntimeException("invalid capture group name");
        }
        return name;
    }

    public static int toCodepoint(String character) {
        if (character.length() > 0) {
            return character.codePointAt(0);
        }
        return 0;
    }
}

