/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.core;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import dev.yasint.regexsynth.core.Expression;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class RegexSynth {
    private RegexSynth() {
    }

    public static String regexp(Expression ... expressions) {
        return Arrays.stream(expressions).map(Expression::toRegex).collect(Collectors.joining());
    }

    public static Pattern compile(String expression, Flags ... flags) {
        int fl = 0;
        for (Flags flag : flags) {
            fl += flag.val;
        }
        return Pattern.compile((String)expression, (int)fl);
    }

    public static Map<Integer, String> getMatchedGroups(Matcher matcher) {
        HashMap<Integer, String> groups = new HashMap<Integer, String>();
        while (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                groups.put(i, matcher.group(i));
            }
        }
        return groups;
    }

    public static enum Flags {
        CASE_INSENSITIVE(1),
        MULTILINE(4),
        DOTALL(2),
        DISABLE_UNICODE_GROUPS(8);

        public final int val;

        private Flags(int val) {
            this.val = val;
        }
    }
}

