/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.ast;

import dev.yasint.regexsynth.core.Constructs;
import dev.yasint.regexsynth.core.Expression;
import dev.yasint.regexsynth.core.Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public final class TrieStructure
implements Expression {
    private final Node root = new Node();

    TrieStructure() {
    }

    public void insert(String word) {
        Node current = this.root;
        for (int i = 0; i < word.length(); ++i) {
            String c = "" + word.charAt(i);
            if (!current.containsKey(c)) {
                current.put(c, new Node());
            }
            current = current.get(c);
        }
        current.put("", null);
    }

    public void insertAll(Collection<String> words) {
        for (String word : words) {
            this.insert(word);
        }
    }

    @Override
    public StringBuilder toRegex() {
        return this.root.toRegex();
    }

    private static final class Node {
        private final Map<String, Node> nodes = new TreeMap<String, Node>();

        private Node() {
        }

        private StringBuilder toRegex() {
            if (this.nodes.containsKey("") && this.nodes.size() == 1) {
                return null;
            }
            ArrayList<String> alternations = new ArrayList<String>();
            ArrayList<String> charClasses = new ArrayList<String>();
            boolean hasOptionals = false;
            for (Map.Entry<String, Node> entry : this.nodes.entrySet()) {
                String escaped = Utility.asRegexLiteral(entry.getKey());
                if (entry.getValue() != null) {
                    StringBuilder subExpression = entry.getValue().toRegex();
                    if (subExpression != null) {
                        alternations.add((String)escaped + subExpression.toString());
                        continue;
                    }
                    charClasses.add(escaped);
                    continue;
                }
                hasOptionals = true;
            }
            boolean hasCharClass = alternations.isEmpty();
            if (charClasses.size() > 0) {
                if (charClasses.size() == 1) {
                    alternations.add((String)charClasses.get(0));
                } else {
                    StringBuilder set = new StringBuilder();
                    set.append(Constructs.OPEN_SQUARE_BRACKET);
                    for (String it : charClasses) {
                        set.append(it);
                    }
                    set.append(Constructs.CLOSE_SQUARE_BRACKET);
                    alternations.add(set.toString());
                }
            }
            StringBuilder expression = new StringBuilder();
            if (alternations.size() == 1) {
                expression.append((String)alternations.get(0));
            } else {
                expression.append(Constructs.PAREN_OPEN).append(Constructs.QUESTION_MARK).append(Constructs.COLON);
                for (int i = 0; i < alternations.size(); ++i) {
                    expression.append((String)alternations.get(i));
                    if (i == alternations.size() - 1) continue;
                    expression.append("|");
                }
                expression.append(Constructs.PAREN_CLOSE);
            }
            if (hasOptionals) {
                if (hasCharClass) {
                    return expression.append(Constructs.QUESTION_MARK);
                }
                expression.insert(0, "" + Constructs.PAREN_OPEN + Constructs.QUESTION_MARK + Constructs.COLON);
                expression.append(Constructs.PAREN_CLOSE).append(Constructs.QUESTION_MARK);
                return expression;
            }
            return expression;
        }

        private boolean containsKey(String key) {
            return this.nodes.containsKey(key);
        }

        private void put(String c, Node node) {
            this.nodes.put(c, node);
        }

        private Node get(String _char) {
            return this.nodes.get(_char);
        }
    }
}

