/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.ast;

import com.google.re2j.Pattern;
import dev.yasint.regexsynth.ast.Literals;
import dev.yasint.regexsynth.core.Constructs;
import dev.yasint.regexsynth.core.Expression;
import dev.yasint.regexsynth.core.UnicodeScript;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public final class RegexSet
implements Expression {
    private static final Pattern SET_RESTRICTED = Pattern.compile((String)"[\\^\\]\\\\\\/\\-\"'`]");
    private Set<String> unicodeClasses;
    private Set<Integer> codepoints;
    private boolean negated;

    RegexSet(boolean negated) {
        this.negated = negated;
        this.codepoints = new TreeSet<Integer>();
        this.unicodeClasses = new HashSet<String>();
    }

    void negate() {
        this.negated = true;
    }

    void addRange(int codepointA, int codepointB) {
        if (Character.isValidCodePoint(codepointA) && Character.isValidCodePoint(codepointB)) {
            if (codepointA > codepointB) {
                throw new IllegalArgumentException("character range is out of order");
            }
            if (codepointA == codepointB) {
                this.codepoints.add(codepointA);
                return;
            }
            for (int i = codepointA; i <= codepointB; ++i) {
                this.codepoints.add(i);
            }
        } else {
            throw new IllegalArgumentException("invalid codepoint");
        }
    }

    void addChar(int codepoint) {
        if (!Character.isValidCodePoint(codepoint)) {
            throw new IllegalArgumentException("invalid codepoint");
        }
        this.codepoints.add(codepoint);
    }

    public RegexSet union(RegexSet b) {
        if (b.negated) {
            this.codepoints.removeAll(b.codepoints);
        } else {
            this.codepoints.addAll(b.codepoints);
        }
        return this;
    }

    public RegexSet intersection(RegexSet b) {
        if (b.negated) {
            this.codepoints.removeAll(b.codepoints);
        } else {
            this.codepoints.retainAll(b.codepoints);
        }
        return this;
    }

    public RegexSet difference(RegexSet b) {
        if (!b.negated) {
            b.negated = true;
        }
        this.intersection(b);
        return this;
    }

    public RegexSet withUnicodeClass(UnicodeScript block, boolean negated) {
        this.unicodeClasses.add(Literals.unicodeClass(block, negated).toRegex().toString());
        return this;
    }

    @Override
    public StringBuilder toRegex() {
        Integer[] chars = this.codepoints.toArray(new Integer[0]);
        if (chars.length == 0 && this.unicodeClasses.isEmpty()) {
            return new StringBuilder(0);
        }
        if (chars.length == 1 && this.unicodeClasses.isEmpty()) {
            return new StringBuilder().append(this.toRegexInterpretable(chars[0]));
        }
        StringBuilder expression = new StringBuilder();
        expression.append(Constructs.OPEN_SQUARE_BRACKET);
        if (this.negated) {
            expression.append(Constructs.CARAT);
        }
        int rangeStartIndex = -1;
        boolean isInRange = false;
        for (int i = 0; i < chars.length; ++i) {
            if (i + 1 < chars.length && chars[i + 1] - chars[i] == 1) {
                if (isInRange) continue;
                rangeStartIndex = i;
                isInRange = true;
                continue;
            }
            if (isInRange) {
                if (i - rangeStartIndex == 1) {
                    expression.append(this.toRegexInterpretable(chars[rangeStartIndex])).append(this.toRegexInterpretable(chars[i]));
                } else {
                    expression.append(this.toRegexInterpretable(chars[rangeStartIndex])).append(Constructs.HYPHEN).append(this.toRegexInterpretable(chars[i]));
                }
                rangeStartIndex = -1;
                isInRange = false;
                continue;
            }
            expression.append(this.toRegexInterpretable(chars[i]));
        }
        if (this.unicodeClasses.size() > 0) {
            for (String klass : this.unicodeClasses) {
                expression.append(klass);
            }
        }
        return expression.append(Constructs.CLOSE_SQUARE_BRACKET);
    }

    private String toRegexInterpretable(int codepoint) {
        String c;
        if (Character.isISOControl(codepoint)) {
            return String.format("\\x%02X", codepoint);
        }
        if (Character.isSupplementaryCodePoint(codepoint)) {
            return String.format("\\x{%s}", Integer.toHexString(codepoint));
        }
        if (Character.isBmpCodePoint(codepoint) && SET_RESTRICTED.matches(c = Character.toString((char)codepoint))) {
            return Constructs.BACKSLASH + c;
        }
        return Character.toString((char)codepoint);
    }
}

