/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.ast;

import dev.yasint.regexsynth.ast.RegexSet;
import dev.yasint.regexsynth.core.Constructs;
import dev.yasint.regexsynth.core.Expression;
import dev.yasint.regexsynth.core.Utility;
import java.util.Objects;

public final class CharClasses {
    public static Expression anything() {
        return () -> new StringBuilder(1).append(Constructs.PERIOD);
    }

    public static RegexSet negated(RegexSet set) {
        set.negate();
        return set;
    }

    public static RegexSet rangedSet(String from, String to) {
        if (from == null || to == null) {
            throw new NullPointerException();
        }
        RegexSet set = new RegexSet(false);
        set.addRange(Utility.toCodepoint(from), Utility.toCodepoint(to));
        return set;
    }

    public static RegexSet rangedSet(int codepointA, int codepointB) {
        RegexSet set = new RegexSet(false);
        set.addRange(codepointA, codepointB);
        return set;
    }

    public static RegexSet simpleSet(String ... characters) {
        RegexSet set = new RegexSet(false);
        for (String c : Objects.requireNonNull(characters)) {
            if (c.length() > 2) {
                throw new RuntimeException("bmp or astral codepoint required");
            }
            set.addChar(Utility.toCodepoint(c));
        }
        return set;
    }

    public static RegexSet simpleSet(int ... codepoints) {
        RegexSet set = new RegexSet(false);
        for (int c : Objects.requireNonNull(codepoints)) {
            set.addChar(c);
        }
        return set;
    }

    public static class EscapeSequences {
        public static RegexSet backslash() {
            return CharClasses.simpleSet("\\");
        }

        public static RegexSet doubleQuotes() {
            return CharClasses.simpleSet("\"");
        }

        public static RegexSet singleQuote() {
            return CharClasses.simpleSet("'");
        }

        public static RegexSet backtick() {
            return CharClasses.simpleSet("`");
        }

        public static RegexSet bell() {
            return CharClasses.simpleSet(7);
        }

        public static RegexSet horizontalTab() {
            return CharClasses.simpleSet(9);
        }

        public static RegexSet linebreak() {
            return CharClasses.simpleSet(10);
        }

        public static RegexSet verticalTab() {
            return CharClasses.simpleSet(11);
        }

        public static RegexSet formfeed() {
            return CharClasses.simpleSet(12);
        }

        public static RegexSet carriageReturn() {
            return CharClasses.simpleSet(13);
        }
    }

    public static class Posix {
        public static RegexSet lowercase() {
            return CharClasses.rangedSet("a", "z");
        }

        public static RegexSet uppercase() {
            return CharClasses.rangedSet("A", "Z");
        }

        public static RegexSet ascii() {
            return CharClasses.rangedSet(0, 127);
        }

        public static RegexSet ascii2() {
            return CharClasses.rangedSet(0, 255);
        }

        public static RegexSet alphabetic() {
            return Posix.lowercase().union(Posix.uppercase());
        }

        public static RegexSet digit() {
            return CharClasses.rangedSet("0", "9");
        }

        public static RegexSet notDigit() {
            return CharClasses.negated(Posix.digit());
        }

        public static RegexSet alphanumeric() {
            return Posix.alphabetic().union(Posix.digit());
        }

        public static RegexSet punctuation() {
            String elements = "!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";
            return CharClasses.simpleSet("!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~".split(""));
        }

        public static RegexSet graphical() {
            return Posix.alphanumeric().union(Posix.punctuation());
        }

        public static RegexSet printableChar() {
            return Posix.graphical().union(CharClasses.simpleSet(32));
        }

        public static RegexSet blank() {
            return CharClasses.simpleSet(9, 32);
        }

        public static RegexSet hexDigit() {
            return Posix.digit().union(CharClasses.rangedSet("a", "f")).union(CharClasses.rangedSet("A", "F"));
        }

        public static RegexSet whitespace() {
            return CharClasses.simpleSet(32, 9, 10, 11, 12, 13);
        }

        public static RegexSet notWhitespace() {
            return CharClasses.negated(Posix.whitespace());
        }

        public static RegexSet word() {
            return Posix.alphanumeric().union(CharClasses.simpleSet("_"));
        }

        public static RegexSet notWord() {
            return CharClasses.negated(Posix.word());
        }
    }
}

