/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.ast;

import com.google.re2j.Pattern;
import dev.yasint.regexsynth.ast.CharClasses;
import dev.yasint.regexsynth.ast.RegexSet;
import dev.yasint.regexsynth.core.Expression;
import dev.yasint.regexsynth.core.RegexSynth;
import dev.yasint.regexsynth.core.UnicodeScript;
import org.junit.Assert;
import org.junit.Test;

public final class RegexSetTest {
    @Test
    public void itShouldCreateANonNegatedCharacterClass() {
        RegexSet simpleSet = CharClasses.simpleSet((String[])new String[]{"A", "B", "D", "E", "C"});
        Assert.assertEquals((Object)simpleSet.toRegex().toString(), (Object)"[A-E]");
    }

    @Test
    public void itShouldCreateANegatedCharacterClass() {
        RegexSet simpleSet = CharClasses.negated((RegexSet)CharClasses.simpleSet((String[])new String[]{"a", "b", "c", "d", "Z"}));
        Assert.assertEquals((Object)simpleSet.toRegex().toString(), (Object)"[^Za-d]");
    }

    @Test
    public void itShouldCreateASimpleCharacterClassWithoutRanges() {
        RegexSet simpleSet = CharClasses.simpleSet((String[])new String[]{"a", "d", "f", "h", "Z"});
        Assert.assertEquals((Object)simpleSet.toRegex().toString(), (Object)"[Zadfh]");
    }

    @Test
    public void itShouldDoASetUnionOperationOnTwoSets() {
        RegexSet rangedSet = CharClasses.rangedSet((String)"A", (String)"Z");
        RegexSet simpleSet = CharClasses.simpleSet((String[])new String[]{"a", "d", "f", "h", "Z"});
        rangedSet.union(simpleSet);
        Assert.assertEquals((Object)rangedSet.toRegex().toString(), (Object)"[A-Zadfh]");
    }

    @Test
    public void itShouldDoASetIntersectionOperationOnTwoSets() {
        RegexSet setA = CharClasses.rangedSet((String)"A", (String)"Z").union(CharClasses.rangedSet((String)"a", (String)"z"));
        RegexSet setB = CharClasses.simpleSet((String[])new String[]{"d", "e", "f"});
        setA.intersection(setB);
        Assert.assertEquals((Object)setA.toRegex().toString(), (Object)"[d-f]");
    }

    @Test
    public void itShouldDoADifferenceOperationOnTwoSets() {
        RegexSet setA = CharClasses.rangedSet((String)"A", (String)"Z").union(CharClasses.rangedSet((String)"a", (String)"z"));
        RegexSet setB = CharClasses.rangedSet((String)"M", (String)"P").union(CharClasses.rangedSet((String)"m", (String)"p"));
        setA.difference(setB);
        Assert.assertEquals((Object)setA.toRegex().toString(), (Object)"[A-LQ-Za-lq-z]");
    }

    @Test
    public void itShouldDoASetUnionOperationOnInlineRegex() {
        Pattern expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{CharClasses.rangedSet((String)"1", (String)"3").union(CharClasses.rangedSet((String)"4", (String)"6"))}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)expression.pattern(), (Object)"[1-6]");
    }

    @Test
    public void itShouldDoASetIntersectionOperationOnInlineRegex() {
        Pattern expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{CharClasses.rangedSet((String)"1", (String)"3").intersection(CharClasses.rangedSet((String)"4", (String)"6"))}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)expression.pattern(), (Object)"");
    }

    @Test
    public void itShouldDoASetDifferenceOperationOnInlineRegex() {
        Pattern expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{CharClasses.rangedSet((String)"1", (String)"3").difference(CharClasses.simpleSet((String[])new String[]{"2", "4", "5", "6"}))}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)expression.pattern(), (Object)"[13]");
    }

    @Test
    public void itShouldAppendANonNegatedUnicodeClassesToASetExpression() {
        Pattern expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{CharClasses.simpleSet((String[])new String[]{"-", "."}).withUnicodeClass(UnicodeScript.SINHALA, false)}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        System.out.println(expression.pattern());
        Assert.assertEquals((Object)expression.pattern(), (Object)"[\\-.\\p{Sinhala}]");
    }

    @Test
    public void itShouldAppendANegatedUnicodeClassesToASetExpression() {
        Pattern expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{CharClasses.simpleSet((String[])new String[]{"-", "."}).withUnicodeClass(UnicodeScript.SINHALA, true)}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        System.out.println(expression.pattern());
        Assert.assertEquals((Object)expression.pattern(), (Object)"[\\-.\\P{Sinhala}]");
    }
}

