/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.ast;

import com.google.re2j.Pattern;
import dev.yasint.regexsynth.ast.CharClasses;
import dev.yasint.regexsynth.ast.Operators;
import dev.yasint.regexsynth.core.Expression;
import dev.yasint.regexsynth.core.RegexSynth;
import org.junit.Assert;
import org.junit.Test;

public final class OperatorsTest {
    @Test
    public void itShouldCreateAlternationBetweenMultipleExpressions() {
        String regexp = RegexSynth.regexp((Expression[])new Expression[]{Operators.either((Expression[])new Expression[]{CharClasses.Posix.digit(), CharClasses.Posix.uppercase(), CharClasses.Posix.lowercase()})});
        Pattern pattern = RegexSynth.compile((String)regexp, (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)pattern.pattern(), (Object)"[0-9]|[A-Z]|[a-z]");
    }

    @Test
    public void itShouldCreateAlternationBetweenMultipleStrings() {
        String regexp = RegexSynth.regexp((Expression[])new Expression[]{Operators.either((String[])new String[]{"http", "https", "ws", "wss"})});
        Pattern pattern = RegexSynth.compile((String)regexp, (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)pattern.pattern(), (Object)"(?:https?|wss?)");
    }

    @Test
    public void itShouldConcatMultipleExpressionsIntoOne() {
        String regexp = RegexSynth.regexp((Expression[])new Expression[]{Operators.concat((Expression)CharClasses.Posix.digit(), (Expression)CharClasses.Posix.punctuation())});
        Pattern pattern = RegexSynth.compile((String)regexp, (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)pattern.pattern(), (Object)"[0-9][!-\\/:-@[-\\`{-~]");
    }
}

