/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.ast;

import dev.yasint.regexsynth.ast.Numeric;
import dev.yasint.regexsynth.core.Expression;
import dev.yasint.regexsynth.core.RegexSynth;
import org.junit.Assert;
import org.junit.Test;

public final class NumericTest {
    @Test
    public void itShouldHandleSmallIntegerRanges() {
        Expression expression = Numeric.integerRange((int)1, (int)10);
        Assert.assertEquals((Object)expression.toRegex().toString(), (Object)"(?:10|[1-9])");
        RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{expression}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        expression = Numeric.integerRange((int)1, (int)100);
        Assert.assertEquals((Object)expression.toRegex().toString(), (Object)"(?:100|[1-9][0-9]|[1-9])");
        RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{expression}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
    }

    @Test
    public void itShouldHandlePreciseIntegerCases() {
        Expression expression = Numeric.integerRange((int)1, (int)25675);
        Assert.assertEquals((Object)expression.toRegex().toString(), (Object)"(?:2567[0-5]|256[0-6][0-9]|25[0-5][0-9][0-9]|2[0-4][0-9][0-9][0-9]|1[0-9][0-9][0-9][0-9]|[1-9][0-9][0-9][0-9]|[1-9][0-9][0-9]|[1-9][0-9]|[1-9])");
        RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{expression}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
    }

    @Test
    public void itShouldHandleRelativelyLargeIntegers() {
        Expression expression = Numeric.integerRange((int)0, (int)999999999);
        Assert.assertEquals((Object)expression.toRegex().toString(), (Object)"(?:[1-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]|[1-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]|[1-9][0-9][0-9][0-9][0-9][0-9][0-9]|[1-9][0-9][0-9][0-9][0-9][0-9]|[1-9][0-9][0-9][0-9][0-9]|[1-9][0-9][0-9][0-9]|[1-9][0-9][0-9]|[1-9][0-9]|[0-9])");
        RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{expression}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
    }

    @Test
    public void itShouldAddALeadingZeroToANumberOrARange() {
        Expression expression = Numeric.leadingZero((Expression)Numeric.integerRange((int)1, (int)12));
        RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{expression}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)expression.toRegex().toString(), (Object)"(?:0?(?:1[0-2]|[1-9]))");
    }
}

