/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.ast;

import com.google.re2j.Pattern;
import dev.yasint.regexsynth.ast.Literals;
import dev.yasint.regexsynth.core.Expression;
import dev.yasint.regexsynth.core.RegexSynth;
import dev.yasint.regexsynth.core.UnicodeScript;
import org.junit.Assert;
import org.junit.Test;

public final class LiteralsTest {
    @Test
    public void itShouldEscapeAllSpecialCharacters() {
        Pattern pattern = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Literals.literal((String)"https://swtch.com/~rsc/regexp&id=1")}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)pattern.pattern(), (Object)"https:\\/\\/swtch\\.com\\/~rsc\\/regexp&id\\=1");
    }

    @Test
    public void itShouldCreateStrictQuoteString() {
        Pattern pattern = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Literals.quotedLiteral((String)"https://swtch.com/~rsc/regexp&id=1")}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)pattern.pattern(), (Object)"\\Qhttps://swtch.com/~rsc/regexp&id=1\\E");
    }

    @Test
    public void itShouldCreateANonNegatedUnicodeScriptBlock() {
        Pattern pattern = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Literals.unicodeClass((UnicodeScript)UnicodeScript.SINHALA, (boolean)false)}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)pattern.pattern(), (Object)"\\p{Sinhala}");
    }

    @Test
    public void itShouldCreateANegatedUnicodeScriptBlock() {
        Pattern pattern = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Literals.unicodeClass((UnicodeScript)UnicodeScript.ARMENIAN, (boolean)true)}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)pattern.pattern(), (Object)"\\P{Armenian}");
    }
}

