/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.ast;

import com.google.re2j.Pattern;
import dev.yasint.regexsynth.ast.CharClasses;
import dev.yasint.regexsynth.ast.Groups;
import dev.yasint.regexsynth.core.Expression;
import dev.yasint.regexsynth.core.RegexSynth;
import org.junit.Assert;
import org.junit.Test;

public final class GroupsTest {
    @Test
    public void itShouldCreateANonCapturingGroup() {
        Pattern pattern = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Groups.nonCaptureGroup((Expression[])new Expression[]{CharClasses.Posix.digit()})}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)pattern.pattern(), (Object)"(?:[0-9])");
    }

    @Test
    public void itShouldCreateACapturingGroup() {
        Pattern pattern = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Groups.nonCaptureGroup((Expression[])new Expression[]{CharClasses.Posix.digit().union(CharClasses.Posix.punctuation())})}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)pattern.pattern(), (Object)"(?:[!-@[-\\`{-~])");
    }

    @Test
    public void itShouldCreateANamedCaptureGroup() {
        Pattern pattern = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Groups.namedCaptureGroup((String)"someName", (Expression[])new Expression[]{CharClasses.Posix.word().union(CharClasses.Posix.punctuation())})}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)pattern.pattern(), (Object)"(?P<someName>[!-~])");
    }

    @Test(expected=RuntimeException.class)
    public void itShouldThrowAnExceptionIfTheNamedCaptureGroupNameIsInvalid() {
        Groups.namedCaptureGroup((String)"- 902 someName", (Expression[])new Expression[]{CharClasses.Posix.word().union(CharClasses.Posix.punctuation())}).toRegex();
    }
}

