/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.ast;

import com.google.re2j.Pattern;
import dev.yasint.regexsynth.ast.Anchors;
import dev.yasint.regexsynth.ast.CharClasses;
import dev.yasint.regexsynth.ast.Groups;
import dev.yasint.regexsynth.ast.Literals;
import dev.yasint.regexsynth.ast.Quantifiers;
import dev.yasint.regexsynth.core.Expression;
import dev.yasint.regexsynth.core.RegexSynth;
import org.junit.Assert;
import org.junit.Test;

public final class AnchorsTest {
    @Test
    public void itShouldAppendAWordBoundaryAtPosition() {
        Pattern expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Groups.captureGroup((Expression[])new Expression[]{Anchors.wordBoundary(), CharClasses.Posix.word()})}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)expression.pattern(), (Object)"(\\b[0-9A-Z_a-z])");
    }

    @Test
    public void itShouldAppendANonWordBoundaryAtPosition() {
        Pattern expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Anchors.nonWordBoundary(), CharClasses.Posix.word()}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)expression.pattern(), (Object)"\\B[0-9A-Z_a-z]");
    }

    @Test
    public void itShouldAppendAStartOfLineAssertionAtPosition() {
        Pattern expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Anchors.startOfLine(), CharClasses.Posix.word()}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)expression.pattern(), (Object)"^[0-9A-Z_a-z]");
    }

    @Test
    public void itShouldAppendEndOfLineAssertionAtPosition() {
        Pattern expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Anchors.startOfLine(), Quantifiers.oneOrMoreTimes((Expression)CharClasses.Posix.word()), Anchors.endOfLine((boolean)false)}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)expression.pattern(), (Object)"^[0-9A-Z_a-z]+$");
    }

    @Test
    public void itShouldAppendEndOfLineAssertionWithOptionalCarriageReturnAtPosition() {
        Pattern expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Anchors.startOfLine(), Quantifiers.oneOrMoreTimes((Expression)CharClasses.Posix.word()), Anchors.endOfLine((boolean)true)}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)expression.pattern(), (Object)"^[0-9A-Z_a-z]+\\x0D?$");
    }

    @Test
    public void itShouldAppendStartOfTextAssertionAtPosition() {
        Pattern expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Anchors.startOfText(), CharClasses.Posix.word()}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)expression.pattern(), (Object)"\\A[0-9A-Z_a-z]");
    }

    @Test
    public void itShouldAppendEndOfTextAssertionAtPosition() {
        Pattern expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{CharClasses.Posix.word(), Anchors.endOfText()}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)expression.pattern(), (Object)"[0-9A-Z_a-z]\\z");
    }

    @Test
    public void itShouldWrapTheExpressionInLineMatcher() {
        Pattern expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Anchors.exactLineMatch((Expression[])new Expression[]{Anchors.wordBoundary(), CharClasses.Posix.word()})}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)expression.pattern(), (Object)"^\\b[0-9A-Z_a-z]$");
    }

    @Test
    public void itShouldWrapTheExpressionInWordBoundary() {
        Pattern expression = RegexSynth.compile((String)RegexSynth.regexp((Expression[])new Expression[]{Anchors.exactWordBoundary((Expression[])new Expression[]{Literals.literal((String)"p"), Quantifiers.oneOrMoreTimes((Expression)CharClasses.Posix.alphabetic()), Literals.literal((String)"p")})}), (RegexSynth.Flags[])new RegexSynth.Flags[0]);
        Assert.assertEquals((Object)expression.pattern(), (Object)"\\bp[A-Za-z]+p\\b");
    }
}

