/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.ast;

import dev.yasint.regexsynth.core.Constructs;
import dev.yasint.regexsynth.core.Expression;
import java.util.Objects;

public final class Quantifiers {
    public static Expression oneOrMoreTimes(Expression expression) {
        return () -> Objects.requireNonNull(expression).toRegex().append(Constructs.PLUS);
    }

    public static Expression zeroOrMoreTimes(Expression expression) {
        return () -> Objects.requireNonNull(expression).toRegex().append(Constructs.ASTERISK);
    }

    public static Expression exactlyOrMoreTimes(int times, Expression expression) {
        if (times == 0) {
            return Quantifiers.zeroOrMoreTimes(expression);
        }
        if (times == 1) {
            return Quantifiers.oneOrMoreTimes(expression);
        }
        return () -> Objects.requireNonNull(expression).toRegex().append(Constructs.OPEN_CURLY_BRACE).append(times).append(Constructs.COMMA).append(Constructs.CLOSE_CURLY_BRACE);
    }

    public static Expression optional(Expression expression) {
        return () -> Objects.requireNonNull(expression).toRegex().append(Constructs.QUESTION_MARK);
    }

    public static Expression exactly(int times, Expression expression) {
        if (times == 0) {
            throw new RuntimeException("redundant sub-sequence");
        }
        if (times == 1) {
            throw new RuntimeException("redundant quantifier");
        }
        return () -> Objects.requireNonNull(expression).toRegex().append(Constructs.OPEN_CURLY_BRACE).append(times).append(Constructs.CLOSE_CURLY_BRACE);
    }

    public static Expression between(int m, int n, Expression expression) {
        if (m > n) {
            throw new RuntimeException("quantifier range is out of order");
        }
        if (m == 0 && n == 0) {
            throw new RuntimeException("redundant sub-sequence");
        }
        if (m == 0 && n == 1) {
            return Quantifiers.optional(expression);
        }
        if (m == 1 && n == 1) {
            return expression;
        }
        return () -> Objects.requireNonNull(expression).toRegex().append(Constructs.OPEN_CURLY_BRACE).append(m).append(Constructs.COMMA).append(n).append(Constructs.CLOSE_CURLY_BRACE);
    }

    public static Expression lazy(Expression expression) {
        return Quantifiers.optional(expression);
    }
}

