/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.ast;

import dev.yasint.regexsynth.ast.CharClasses;
import dev.yasint.regexsynth.ast.Groups;
import dev.yasint.regexsynth.ast.IntegerRange;
import dev.yasint.regexsynth.ast.Literals;
import dev.yasint.regexsynth.core.Constructs;
import dev.yasint.regexsynth.core.Expression;

public final class Numeric {
    public static Expression leadingZero(Expression another) {
        return Groups.nonCaptureGroup(() -> another.toRegex().insert(0, "0" + Constructs.QUESTION_MARK));
    }

    public static Expression integerRange(int from, int to) {
        if (from > to) {
            throw new RuntimeException("integer range is out of order");
        }
        if (from == to) {
            return Literals.literal(String.valueOf(from));
        }
        if (from >= 0 && to <= 9) {
            return CharClasses.rangedSet(String.valueOf(from), String.valueOf(to));
        }
        return Groups.nonCaptureGroup(() -> new StringBuilder(new IntegerRange(from, to).create()));
    }

    private static Expression binary() {
        throw new UnsupportedOperationException();
    }

    private static Expression octal() {
        throw new UnsupportedOperationException();
    }

    private static Expression hex() {
        throw new UnsupportedOperationException();
    }
}

