/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.ast;

import dev.yasint.regexsynth.core.Constructs;
import dev.yasint.regexsynth.core.Expression;
import java.util.Collections;
import java.util.LinkedList;

public final class IntegerRange
implements Expression {
    private final int start;
    private final int end;

    IntegerRange(int start, int end) {
        this.start = start;
        this.end = end;
    }

    private static LinkedList<IntegerRange> leftBounds(int start, int end) {
        LinkedList<IntegerRange> result = new LinkedList<IntegerRange>();
        while (start < end) {
            IntegerRange range = IntegerRange.fromStart(start);
            result.add(range);
            start = range.end + 1;
        }
        return result;
    }

    private static LinkedList<IntegerRange> rightBounds(int start, int end) {
        LinkedList<IntegerRange> result = new LinkedList<IntegerRange>();
        while (start < end) {
            IntegerRange range = IntegerRange.fromEnd(end);
            result.add(range);
            end = range.start - 1;
        }
        Collections.reverse(result);
        return result;
    }

    private static IntegerRange fromEnd(int end) {
        char[] chars = String.valueOf(end).toCharArray();
        for (int i = chars.length - 1; i >= 0; --i) {
            if (chars[i] != '9') {
                chars[i] = 48;
                break;
            }
            chars[i] = 48;
        }
        return new IntegerRange(Integer.parseInt(String.valueOf(chars)), end);
    }

    private static IntegerRange fromStart(int start) {
        char[] chars = String.valueOf(start).toCharArray();
        for (int i = chars.length - 1; i >= 0; --i) {
            if (chars[i] != '0') {
                chars[i] = 57;
                break;
            }
            chars[i] = 57;
        }
        return new IntegerRange(start, Integer.parseInt(String.valueOf(chars)));
    }

    private static IntegerRange join(IntegerRange a, IntegerRange b) {
        return new IntegerRange(a.start, b.end);
    }

    String create() {
        LinkedList<IntegerRange> left = IntegerRange.leftBounds(this.start, this.end);
        IntegerRange lastLeft = left.removeLast();
        LinkedList<IntegerRange> right = IntegerRange.rightBounds(lastLeft.start, this.end);
        IntegerRange firstRight = right.removeFirst();
        LinkedList<IntegerRange> merged = new LinkedList<IntegerRange>(left);
        if (!lastLeft.overlaps(firstRight)) {
            merged.add(lastLeft);
            merged.add(firstRight);
        } else {
            merged.add(IntegerRange.join(lastLeft, firstRight));
        }
        merged.addAll(right);
        StringBuilder expression = new StringBuilder();
        for (int i = merged.size() - 1; i >= 0; --i) {
            expression.append((CharSequence)merged.get(i).toRegex());
            if (i == 0) continue;
            expression.append("|");
        }
        return expression.toString();
    }

    private boolean overlaps(IntegerRange r) {
        return this.end > r.start && r.end > this.start;
    }

    public String toString() {
        return String.format("RangeGen { start=%d, end=%d }", this.start, this.end);
    }

    @Override
    public StringBuilder toRegex() {
        String startStr = String.valueOf(this.start);
        String endStr = String.valueOf(this.end);
        StringBuilder result = new StringBuilder();
        for (int pos = 0; pos < startStr.length(); ++pos) {
            if (startStr.charAt(pos) == endStr.charAt(pos)) {
                result.append(startStr.charAt(pos));
                continue;
            }
            result.append(Constructs.OPEN_SQUARE_BRACKET).append(startStr.charAt(pos)).append(Constructs.HYPHEN).append(endStr.charAt(pos)).append(Constructs.CLOSE_SQUARE_BRACKET);
        }
        return result;
    }
}

