/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.ast;

import dev.yasint.regexsynth.ast.RegexSet;
import dev.yasint.regexsynth.core.Constructs;
import dev.yasint.regexsynth.core.Expression;
import dev.yasint.regexsynth.core.Utility;
import java.util.Objects;

public final class CharClasses {
    public static Expression anything() {
        return () -> new StringBuilder(1).append(Constructs.PERIOD);
    }

    public static RegexSet negated(RegexSet set) {
        set.negate();
        return set;
    }

    public static RegexSet rangedSet(String from, String to) {
        if (from == null || to == null) {
            throw new NullPointerException();
        }
        RegexSet set = new RegexSet(false);
        set.addRange(Utility.toCodepoint(from), Utility.toCodepoint(to));
        return set;
    }

    public static RegexSet rangedSet(int codepointA, int codepointB) {
        RegexSet set = new RegexSet(false);
        set.addRange(codepointA, codepointB);
        return set;
    }

    public static RegexSet simpleSet(String ... characters) {
        RegexSet set = new RegexSet(false);
        for (String c : Objects.requireNonNull(characters)) {
            set.addChar(Utility.toCodepoint(c));
        }
        return set;
    }

    public static RegexSet simpleSet(int ... codepoints) {
        RegexSet set = new RegexSet(false);
        for (int c : Objects.requireNonNull(codepoints)) {
            set.addChar(c);
        }
        return set;
    }

    public static class EscapeSequences {
        public static RegexSet backslash() {
            return CharClasses.simpleSet("\\");
        }

        public static RegexSet bell() {
            return CharClasses.simpleSet(7);
        }

        public static RegexSet horizontalTab() {
            return CharClasses.simpleSet(9);
        }

        public static RegexSet linebreak() {
            return CharClasses.simpleSet(10);
        }

        public static RegexSet verticalTab() {
            return CharClasses.simpleSet(11);
        }

        public static RegexSet formfeed() {
            return CharClasses.simpleSet(12);
        }

        public static RegexSet carriageReturn() {
            return CharClasses.simpleSet(13);
        }
    }

    public static class Posix {
        public static RegexSet lowercaseChar() {
            return CharClasses.rangedSet("a", "z");
        }

        public static RegexSet uppercaseChar() {
            return CharClasses.rangedSet("A", "Z");
        }

        public static RegexSet asciiChar() {
            return CharClasses.rangedSet(0, 127);
        }

        public static RegexSet ascii2Char() {
            return CharClasses.rangedSet(0, 255);
        }

        public static RegexSet alphabeticChar() {
            return Posix.lowercaseChar().union(Posix.uppercaseChar());
        }

        public static RegexSet digit() {
            return CharClasses.rangedSet("0", "9");
        }

        public static RegexSet notDigit() {
            return CharClasses.negated(Posix.digit());
        }

        public static RegexSet alphanumericChar() {
            return Posix.alphabeticChar().union(Posix.digit());
        }

        public static RegexSet punctuationChar() {
            String elements = "!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";
            return CharClasses.simpleSet("!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~".split(""));
        }

        public static RegexSet graphicalChar() {
            return Posix.alphanumericChar().union(Posix.punctuationChar());
        }

        public static RegexSet printableChar() {
            return Posix.graphicalChar().union(CharClasses.simpleSet(32));
        }

        public static RegexSet blankChar() {
            return CharClasses.simpleSet(9, 32);
        }

        public static RegexSet hexDigit() {
            return Posix.digit().union(CharClasses.rangedSet("a", "f")).union(CharClasses.rangedSet("A", "F"));
        }

        public static RegexSet whitespaceChar() {
            return CharClasses.simpleSet(32, 9, 10, 11, 12, 13);
        }

        public static RegexSet notWhitespace() {
            return CharClasses.negated(Posix.whitespaceChar());
        }

        public static RegexSet word() {
            return Posix.alphanumericChar().union(CharClasses.simpleSet("_"));
        }

        public static RegexSet notWord() {
            return CharClasses.negated(Posix.word());
        }
    }
}

