/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.ast;

import dev.yasint.regexsynth.core.Constructs;
import dev.yasint.regexsynth.core.Expression;
import java.util.Arrays;

public final class Anchors {
    public static Expression wordBoundary() {
        return () -> new StringBuilder(2).append(Constructs.WORD_BOUNDARY);
    }

    public static Expression nonWordBoundary() {
        return () -> new StringBuilder(2).append(Constructs.NON_WORD_BOUNDARY);
    }

    public static Expression startOfLine() {
        return () -> new StringBuilder(1).append(Constructs.CARAT);
    }

    public static Expression endOfLine(boolean crlf) {
        return () -> new StringBuilder(6).append(crlf ? "\\x0D?" : "").append(Constructs.DOLLAR);
    }

    public static Expression startOfText() {
        return () -> new StringBuilder(2).append(Constructs.BEGINNING_OF_TEXT);
    }

    public static Expression endOfText() {
        return () -> new StringBuilder(2).append(Constructs.END_OF_TEXT);
    }

    public static Expression exactLineMatch(Expression ... expressions) {
        return () -> Arrays.stream(expressions).map(Expression::toRegex).reduce(new StringBuilder().append(Constructs.CARAT), StringBuilder::append).append(Constructs.DOLLAR);
    }

    public static Expression exactWordBoundary(Expression ... expressions) {
        return () -> Arrays.stream(expressions).map(Expression::toRegex).reduce(new StringBuilder().append(Constructs.WORD_BOUNDARY), StringBuilder::append).append(Constructs.WORD_BOUNDARY);
    }
}

