/*
 * Decompiled with CFR 0.152.
 */
package dev.yasint.regexsynth.core;

import com.google.re2j.Pattern;
import dev.yasint.regexsynth.ast.Anchors;
import dev.yasint.regexsynth.ast.CharClasses;
import dev.yasint.regexsynth.ast.Groups;
import dev.yasint.regexsynth.ast.Literals;
import dev.yasint.regexsynth.ast.Numeric;
import dev.yasint.regexsynth.ast.Operators;
import dev.yasint.regexsynth.ast.Quantifiers;
import dev.yasint.regexsynth.core.Expression;
import dev.yasint.regexsynth.core.RegexSynth;
import java.time.Year;
import org.junit.Assert;
import org.junit.Test;

public final class RegexSynthTest {
    @Test
    public void itShouldCreateTheExpectedDateExpression() {
        String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        String expression = RegexSynth.regexp((Expression[])new Expression[]{Anchors.exactLineMatch((Expression[])new Expression[]{Numeric.integerRange((int)2012, (int)Year.now().getValue()), Literals.literal((String)"-"), Groups.captureGroup((Expression[])new Expression[]{Operators.either((String[])months)}), Literals.literal((String)"-"), Groups.captureGroup((Expression[])new Expression[]{Numeric.leadingZero((Expression)Numeric.integerRange((int)1, (int)31))})})});
        Pattern pattern = RegexSynth.compile((String)expression, (RegexSynth.Flags[])new RegexSynth.Flags[]{RegexSynth.Flags.MULTILINE});
        Assert.assertEquals((Object)pattern.pattern(), (Object)"^(?:2020|201[2-9])\\-((?:A(?:pr|ug)|Dec|Feb|J(?:an|u[ln])|Ma[ry]|Nov|Oct|Sep))\\-((?:0?(?:3[0-1]|[1-2][0-9]|[1-9])))$");
    }

    @Test
    public void itShouldCreateCorrectURLExpression() {
        String expression = RegexSynth.regexp((Expression[])new Expression[]{Anchors.exactLineMatch((Expression[])new Expression[]{Groups.namedCaptureGroup((String)"protocol", (Expression[])new Expression[]{Operators.either((String[])new String[]{"http", "https", "ftp"})}), Literals.literal((String)"://"), Groups.namedCaptureGroup((String)"subDomain", (Expression[])new Expression[]{Quantifiers.oneOrMoreTimes((Expression)CharClasses.Posix.alphanumericChar().union(CharClasses.simpleSet((String[])new String[]{"-", "."})))}), Literals.literal((String)"."), Groups.namedCaptureGroup((String)"tld", (Expression[])new Expression[]{Quantifiers.between((int)2, (int)4, (Expression)CharClasses.Posix.alphabeticChar())}), Quantifiers.optional((Expression)Groups.namedCaptureGroup((String)"port", (Expression[])new Expression[]{Literals.literal((String)":"), Quantifiers.oneOrMoreTimes((Expression)CharClasses.Posix.digit())})), Quantifiers.optional((Expression)Literals.literal((String)"/")), Groups.namedCaptureGroup((String)"resource", (Expression[])new Expression[]{Quantifiers.zeroOrMoreTimes((Expression)CharClasses.anything())})})});
        Pattern pattern = RegexSynth.compile((String)expression, (RegexSynth.Flags[])new RegexSynth.Flags[]{RegexSynth.Flags.MULTILINE});
    }
}

